/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.playground.sevice;

import java.util.HashMap;
import java.util.Map;
import org.camunda.feel.FeelEngine;
import org.camunda.feel.impl.JavaValueMapper;
import org.camunda.feel.valuemapper.CustomValueMapper;
import org.springframework.stereotype.Component;
import scala.util.Either;

@Component
public final class FeelEvaluationService {
    private final FeelEngine feelEngine = new FeelEngine.Builder().customValueMapper((CustomValueMapper)new JavaValueMapper()).build();

    public Object evaluate(String expression, Map<String, Object> context) {
        Either evaluationResult = this.feelEngine.evalExpression(expression, context);
        if (evaluationResult.isRight()) {
            return evaluationResult.right().get();
        }
        FeelEngine.Failure failure = (FeelEngine.Failure)evaluationResult.left().get();
        throw new RuntimeException(failure.message());
    }

    public Object evaluateUnaryTests(String expression, Object inputValue, Map<String, Object> context) {
        HashMap<String, Object> contextWithInput = new HashMap<String, Object>(context);
        contextWithInput.put("cellInput", inputValue);
        Either evaluationResult = this.feelEngine.evalUnaryTests(expression, contextWithInput);
        if (evaluationResult.isRight()) {
            return evaluationResult.right().get();
        }
        FeelEngine.Failure failure = (FeelEngine.Failure)evaluationResult.left().get();
        throw new RuntimeException(failure.message());
    }
}

