/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.playground.api;

import org.camunda.feel.playground.dto.FeelEvaluationRequest;
import org.camunda.feel.playground.dto.FeelEvaluationResponse;
import org.camunda.feel.playground.dto.FeelUnaryTestsEvaluationRequest;
import org.camunda.feel.playground.sevice.FeelEvaluationService;
import org.camunda.feel.playground.sevice.TrackingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1"})
@CrossOrigin
public class FeelEvaluationController {
    private static final Logger LOG = LoggerFactory.getLogger(FeelEvaluationController.class);
    private final FeelEvaluationService evaluationService;
    private final TrackingService trackingService;

    public FeelEvaluationController(FeelEvaluationService evaluationService, TrackingService trackingService) {
        this.evaluationService = evaluationService;
        this.trackingService = trackingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/feel/evaluate"})
    public ResponseEntity<FeelEvaluationResponse> evaluate(@RequestBody FeelEvaluationRequest request) {
        LOG.debug("Evaluate FEEL expression: {}", (Object)request);
        try {
            Object result = this.evaluationService.evaluate(request.expression, request.context);
            ResponseEntity responseEntity = new ResponseEntity((Object)FeelEvaluationResponse.withResult(result), (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        catch (Exception e) {
            ResponseEntity responseEntity = new ResponseEntity((Object)FeelEvaluationResponse.withError(e.getMessage()), (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        finally {
            this.trackingService.trackExpressionEvaluation(request.metadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/feel-unary-tests/evaluate"})
    public ResponseEntity<FeelEvaluationResponse> evaluateUnaryTests(@RequestBody FeelUnaryTestsEvaluationRequest request) {
        LOG.debug("Evaluate FEEL unary-tests expression: {}", (Object)request);
        try {
            Object result = this.evaluationService.evaluateUnaryTests(request.expression, request.inputValue, request.context);
            ResponseEntity responseEntity = new ResponseEntity((Object)FeelEvaluationResponse.withResult(result), (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        catch (Exception e) {
            ResponseEntity responseEntity = new ResponseEntity((Object)FeelEvaluationResponse.withError(e.getMessage()), (HttpStatusCode)HttpStatus.OK);
            return responseEntity;
        }
        finally {
            this.trackingService.trackUnaryTestsExpressionEvaluation(request.metadata);
        }
    }
}

