/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.playground.sevice;

import com.mixpanel.mixpanelapi.MessageBuilder;
import com.mixpanel.mixpanelapi.MixpanelAPI;
import java.util.Map;
import java.util.Optional;
import org.camunda.feel.playground.sevice.MixpanelProperties;
import org.camunda.feel.playground.sevice.TrackingService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnBean(value={MixpanelProperties.class})
public class MixpanelTrackingService
implements TrackingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MixpanelTrackingService.class);
    private final MixpanelAPI mixpanelAPI = new MixpanelAPI();
    private final MessageBuilder messageBuilder;

    public MixpanelTrackingService(MixpanelProperties mixpanelProperties) {
        this.messageBuilder = new MessageBuilder(mixpanelProperties.getProjectToken());
    }

    private void sendMixpanelEvent(EVENT_TYPE eventType, Map<String, String> metadata) {
        JSONObject properties = new JSONObject();
        Optional.ofNullable(metadata).ifPresent(entry -> entry.forEach((arg_0, arg_1) -> ((JSONObject)properties).put(arg_0, arg_1)));
        JSONObject message = this.messageBuilder.event(null, eventType.name(), properties);
        try {
            this.mixpanelAPI.sendMessage(message);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to send Mixpanel event.", (Throwable)e);
        }
    }

    @Override
    public void trackExpressionEvaluation(Map<String, String> metadata) {
        this.sendMixpanelEvent(EVENT_TYPE.FEEL_EXPRESSION_EVALUATION, metadata);
    }

    @Override
    public void trackUnaryTestsExpressionEvaluation(Map<String, String> metadata) {
        this.sendMixpanelEvent(EVENT_TYPE.FEEL_UNARY_TESTS_EXPRESSION_EVALUATION, metadata);
    }

    private static enum EVENT_TYPE {
        FEEL_EXPRESSION_EVALUATION,
        FEEL_UNARY_TESTS_EXPRESSION_EVALUATION;

    }
}

