/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.feel.playground.sevice;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.camunda.feel.FeelEngine;
import org.camunda.feel.api.EvaluationResult;
import org.camunda.feel.api.FeelEngineApi;
import org.camunda.feel.impl.JavaValueMapper;
import org.camunda.feel.syntaxtree.Val;
import org.camunda.feel.syntaxtree.ValDate;
import org.camunda.feel.syntaxtree.ValDateTime;
import org.camunda.feel.syntaxtree.ValDayTimeDuration;
import org.camunda.feel.syntaxtree.ValLocalDateTime;
import org.camunda.feel.syntaxtree.ValLocalTime;
import org.camunda.feel.syntaxtree.ValTime;
import org.camunda.feel.syntaxtree.ValYearMonthDuration;
import org.camunda.feel.valuemapper.CustomValueMapper;
import org.camunda.feel.valuemapper.JavaCustomValueMapper;
import org.springframework.stereotype.Component;

@Component
public final class FeelEvaluationService {
    private final FeelEngineApi feelEngineApi = this.buildFeelEngine();

    private FeelEngineApi buildFeelEngine() {
        FeelEngine feelEngine = new FeelEngine.Builder().customValueMapper((CustomValueMapper)new JavaValueMapperWithTemporalStringDeserialization()).build();
        return new FeelEngineApi(feelEngine);
    }

    public EvaluationResult evaluate(String expression, Map<String, Object> context) {
        return this.feelEngineApi.evaluateExpression(expression, context);
    }

    public EvaluationResult evaluateUnaryTests(String expression, Object inputValue, Map<String, Object> context) {
        return this.feelEngineApi.evaluateUnaryTests(expression, inputValue, context);
    }

    private static class JavaValueMapperWithTemporalStringDeserialization
    extends JavaCustomValueMapper {
        private final CustomValueMapper baseValueMapper = new JavaValueMapper();

        private JavaValueMapperWithTemporalStringDeserialization() {
        }

        public Optional<Val> toValue(Object x, Function<Object, Val> innerValueMapper) {
            return (Optional)this.baseValueMapper.toVal(x, innerValueMapper::apply).fold(Optional::empty, Optional::of);
        }

        public Optional<Object> unpackValue(Val value, Function<Val, Object> innerValueMapper) {
            if (JavaValueMapperWithTemporalStringDeserialization.isTemporalValue(value)) {
                return Optional.of(value.toString());
            }
            return (Optional)this.baseValueMapper.unpackVal(value, innerValueMapper::apply).fold(Optional::empty, Optional::of);
        }

        private static boolean isTemporalValue(Val value) {
            return value instanceof ValDate || value instanceof ValTime || value instanceof ValLocalTime || value instanceof ValDateTime || value instanceof ValLocalDateTime || value instanceof ValDayTimeDuration || value instanceof ValYearMonthDuration;
        }
    }
}

