/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.conversion;

import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.BpmnElementFactory;
import org.camunda.community.migration.converter.conversion.AbstractTypedConversion;
import org.camunda.community.migration.converter.convertible.UserTaskConvertible;

public class UserTaskConversion
extends AbstractTypedConversion<UserTaskConvertible> {
    @Override
    protected void convertTyped(DomElement element, UserTaskConvertible convertible) {
        DomElement extensionElements = BpmnElementFactory.getExtensionElements(element);
        if (convertible.isZeebeUserTask()) {
            extensionElements.appendChild(this.createZeebeUserTask(element.getDocument()));
        }
        if (this.canAddFormDefinition(convertible)) {
            extensionElements.appendChild(this.createFormDefinition(element.getDocument(), convertible));
        }
        if (this.canAddAssignmentDefinition(convertible)) {
            extensionElements.appendChild(this.createAssignmentDefinition(element.getDocument(), convertible));
        }
        if (this.canAddTaskSchedule(convertible)) {
            extensionElements.appendChild(this.createTaskSchedule(element.getDocument(), convertible));
        }
    }

    private DomElement createZeebeUserTask(DomDocument document) {
        return document.createElement("http://camunda.org/schema/zeebe/1.0", "userTask");
    }

    private DomElement createTaskSchedule(DomDocument document, UserTaskConvertible convertible) {
        DomElement taskSchedule = document.createElement("http://camunda.org/schema/zeebe/1.0", "taskSchedule");
        taskSchedule.setAttribute("dueDate", convertible.getZeebeTaskSchedule().getDueDate());
        taskSchedule.setAttribute("followUpDate", convertible.getZeebeTaskSchedule().getFollowUpDate());
        return taskSchedule;
    }

    private boolean canAddTaskSchedule(UserTaskConvertible convertible) {
        return convertible.getZeebeTaskSchedule().getDueDate() != null || convertible.getZeebeTaskSchedule().getFollowUpDate() != null;
    }

    private DomElement createFormDefinition(DomDocument document, UserTaskConvertible convertible) {
        DomElement formDefinition = document.createElement("http://camunda.org/schema/zeebe/1.0", "formDefinition");
        formDefinition.setAttribute("http://camunda.org/schema/zeebe/1.0", "formKey", convertible.getZeebeFormDefinition().getFormKey());
        if (convertible.getZeebeFormDefinition().getBindingType() != null) {
            formDefinition.setAttribute("http://camunda.org/schema/zeebe/1.0", "bindingType", convertible.getZeebeFormDefinition().getBindingType().name());
        }
        if (StringUtils.isNotBlank(convertible.getZeebeFormDefinition().getVersionTag())) {
            formDefinition.setAttribute("http://camunda.org/schema/zeebe/1.0", "versionTag", convertible.getZeebeFormDefinition().getVersionTag());
        }
        return formDefinition;
    }

    private DomElement createAssignmentDefinition(DomDocument document, UserTaskConvertible convertible) {
        DomElement assignmentDefinition = document.createElement("http://camunda.org/schema/zeebe/1.0", "assignmentDefinition");
        assignmentDefinition.setAttribute("assignee", convertible.getZeebeAssignmentDefinition().getAssignee());
        assignmentDefinition.setAttribute("candidateGroups", convertible.getZeebeAssignmentDefinition().getCandidateGroups());
        assignmentDefinition.setAttribute("candidateUsers", convertible.getZeebeAssignmentDefinition().getCandidateUsers());
        return assignmentDefinition;
    }

    private boolean canAddFormDefinition(UserTaskConvertible convertible) {
        return convertible.getZeebeFormDefinition().getFormKey() != null;
    }

    private boolean canAddAssignmentDefinition(UserTaskConvertible convertible) {
        return convertible.getZeebeAssignmentDefinition().getAssignee() != null || convertible.getZeebeAssignmentDefinition().getCandidateGroups() != null || convertible.getZeebeAssignmentDefinition().getCandidateUsers() != null;
    }

    @Override
    protected Class<UserTaskConvertible> type() {
        return UserTaskConvertible.class;
    }
}

