/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import java.util.Objects;
import org.springframework.aot.hint.ConditionalHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;

public final class ResourceBundleHint
implements ConditionalHint {
    private final String baseName;
    @Nullable
    private final TypeReference reachableType;

    ResourceBundleHint(Builder builder) {
        this.baseName = builder.baseName;
        this.reachableType = builder.reachableType;
    }

    public String getBaseName() {
        return this.baseName;
    }

    @Override
    @Nullable
    public TypeReference getReachableType() {
        return this.reachableType;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceBundleHint that = (ResourceBundleHint)o;
        return this.baseName.equals(that.baseName) && Objects.equals(this.reachableType, that.reachableType);
    }

    public int hashCode() {
        return Objects.hash(this.baseName, this.reachableType);
    }

    public static class Builder {
        private String baseName;
        @Nullable
        private TypeReference reachableType;

        Builder(String baseName) {
            this.baseName = baseName;
        }

        public Builder onReachableType(TypeReference reachableType) {
            this.reachableType = reachableType;
            return this;
        }

        public Builder baseName(String baseName) {
            this.baseName = baseName;
            return this;
        }

        ResourceBundleHint build() {
            return new ResourceBundleHint(this);
        }
    }
}

