/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.CompensateEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EndEvent;
import io.camunda.zeebe.model.bpmn.instance.ErrorEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EscalationEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.TerminateEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListener;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeExecutionListenerEventType;
import io.camunda.zeebe.model.bpmn.util.ModelUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class EndEventValidator
implements ModelElementValidator<EndEvent> {
    private static final List<Class<? extends EventDefinition>> SUPPORTED_EVENT_DEFINITIONS = Arrays.asList(ErrorEventDefinition.class, MessageEventDefinition.class, TerminateEventDefinition.class, SignalEventDefinition.class, EscalationEventDefinition.class, CompensateEventDefinition.class);

    @Override
    public Class<EndEvent> getElementType() {
        return EndEvent.class;
    }

    @Override
    public void validate(EndEvent element, ValidationResultCollector validationResultCollector) {
        if (!element.getOutgoing().isEmpty()) {
            validationResultCollector.addError(0, "End events must not have outgoing sequence flows to other elements.");
        }
        this.validateEventDefinition(element, validationResultCollector);
        ModelUtil.validateExecutionListenersDefinitionForElement(element, validationResultCollector, listeners -> {
            Collection<EventDefinition> eventDefinitions = element.getEventDefinitions();
            eventDefinitions.stream().findFirst().ifPresent(eventDefinition -> {
                if (eventDefinition instanceof ErrorEventDefinition) {
                    boolean endExecutionListenersDefined = listeners.stream().map(ZeebeExecutionListener::getEventType).anyMatch(ZeebeExecutionListenerEventType.end::equals);
                    if (endExecutionListenersDefined) {
                        validationResultCollector.addError(0, "Execution listeners of type 'end' are not supported by [error] end events");
                    }
                }
            });
        });
    }

    private void validateEventDefinition(EndEvent element, ValidationResultCollector validationResultCollector) {
        Collection<EventDefinition> eventDefinitions = element.getEventDefinitions();
        if (eventDefinitions.size() > 1) {
            validationResultCollector.addError(0, "Must have at most one event definition");
        }
        eventDefinitions.forEach(def -> {
            String waitForCompletion;
            if (SUPPORTED_EVENT_DEFINITIONS.stream().noneMatch(type -> type.isInstance(def))) {
                validationResultCollector.addError(0, "End events must be one of: none, error, message, terminate, signal, escalation or compensation");
            }
            if (def instanceof CompensateEventDefinition && (waitForCompletion = def.getAttributeValue("waitForCompletion")) != null && !Boolean.parseBoolean(waitForCompletion)) {
                validationResultCollector.addError(0, "A compensation end event waitForCompletion attribute must be true or not present");
            }
        });
    }
}

