/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeBindingType;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class ZeebeBindingTypeValidator<T extends ModelElementInstance>
implements ModelElementValidator<T> {
    private static final List<String> ALLOWED_BINDING_TYPES = Arrays.stream(ZeebeBindingType.values()).map(Enum::toString).collect(Collectors.toList());
    private final Class<T> elementType;

    public ZeebeBindingTypeValidator(Class<T> elementType) {
        this.elementType = elementType;
    }

    @Override
    public Class<T> getElementType() {
        return this.elementType;
    }

    @Override
    public void validate(T element, ValidationResultCollector validationResultCollector) {
        String bindingType = element.getAttributeValue("bindingType");
        String versionTag = element.getAttributeValue("versionTag");
        ZeebeBindingTypeValidator.checkValidBindingTypeValue(validationResultCollector, bindingType);
        ZeebeBindingTypeValidator.checkValidBindingTypeAndVersionTag(validationResultCollector, bindingType, versionTag);
    }

    private static void checkValidBindingTypeValue(ValidationResultCollector validationResultCollector, String bindingType) {
        if (bindingType != null && !ALLOWED_BINDING_TYPES.contains(bindingType)) {
            String message = String.format("Attribute '%s' must be one of: %s", "bindingType", String.join((CharSequence)", ", ALLOWED_BINDING_TYPES));
            validationResultCollector.addError(0, message);
        }
    }

    private static void checkValidBindingTypeAndVersionTag(ValidationResultCollector validationResultCollector, String bindingType, String versionTag) {
        if (ZeebeBindingType.versionTag.name().equals(bindingType) && ZeebeBindingTypeValidator.isBlank(versionTag)) {
            validationResultCollector.addError(0, String.format("Attribute '%s' must be present and not empty if '%s' is '%s'", new Object[]{"versionTag", "bindingType", ZeebeBindingType.versionTag}));
        } else if (!ZeebeBindingType.versionTag.name().equals(bindingType) && !ZeebeBindingTypeValidator.isBlank(versionTag)) {
            validationResultCollector.addError(0, String.format("Attribute '%s' may only be used if '%s' is '%s'", new Object[]{"versionTag", "bindingType", ZeebeBindingType.versionTag}));
        }
    }

    private static boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }
}

