/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.cli;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.community.migration.converter.BpmnConverter;
import org.camunda.community.migration.converter.BpmnConverterFactory;
import org.camunda.community.migration.converter.BpmnDiagramCheckResult;
import org.camunda.community.migration.converter.ConverterPropertiesFactory;
import org.camunda.community.migration.converter.DefaultConverterProperties;
import org.camunda.community.migration.converter.cli.ConvertCommand;
import org.camunda.community.migration.converter.cli.PrintNotificationServiceImpl;
import picocli.CommandLine;

public abstract class AbstractConvertCommand
implements Callable<Integer> {
    private static final String DEFAULT_PREFIX = "converted-c8-";
    protected final BpmnConverter converter;
    protected int returnCode = 0;
    @CommandLine.Option(names={"-d", "--documentation"}, description={"If enabled, messages are also appended to documentation"})
    boolean documentation;
    @CommandLine.Option(names={"--default-job-type"}, description={"If set, the default value from the 'converter-properties.properties' for the job type is overridden"})
    String defaultJobType;
    @CommandLine.Option(names={"--prefix"}, description={"Prefix for the name of the generated file"}, defaultValue="converted-c8-")
    String prefix = "converted-c8-";
    @CommandLine.Option(names={"-o", "--override"}, description={"If enabled, existing files are overridden"})
    boolean override;
    @CommandLine.Option(names={"--platform-version"}, description={"Semantic version of the target platform, defaults to latest version"})
    String platformVersion;
    @CommandLine.Option(names={"--csv"}, description={"If enabled, a CSV file will be created containing the results for all conversions"})
    boolean csv;
    @CommandLine.Option(names={"--md", "--markdown"}, description={"If enabled, a markdown file will be created containing the results for all conversions"})
    boolean markdown;
    @CommandLine.Option(names={"--delegate-execution-as-job-type"}, description={"If enabled, sets the delegate expression as the job type"})
    boolean delegateExecutionAsJobType;
    @CommandLine.Option(names={"--check"}, description={"If enabled, no converted diagrams are exported"})
    boolean check;
    @CommandLine.Option(names={"--disable-default-job-type"}, description={"Disables the default job type"})
    boolean defaultJobTypeDisabled;
    @CommandLine.Option(names={"--disable-append-elements"}, description={"Disables adding conversion messages to the bpmn xml"})
    boolean disableAppendElements;

    public AbstractConvertCommand() {
        BpmnConverterFactory factory = BpmnConverterFactory.getInstance();
        factory.getNotificationServiceFactory().setInstance(new PrintNotificationServiceImpl());
        this.converter = (BpmnConverter)factory.get();
    }

    @Override
    public final Integer call() {
        this.returnCode = 0;
        Map<File, BpmnModelInstance> modelInstances = this.modelInstances();
        List<BpmnDiagramCheckResult> results = this.checkModels(modelInstances);
        this.writeResults(modelInstances, results);
        return this.returnCode;
    }

    private void writeResults(Map<File, BpmnModelInstance> modelInstances, List<BpmnDiagramCheckResult> results) {
        FileWriter fw;
        if (!this.check) {
            for (Map.Entry<File, BpmnModelInstance> modelInstance : modelInstances.entrySet()) {
                File file = this.determineFileName(this.prefixFileName(modelInstance.getKey()));
                if (!this.override && file.exists()) {
                    ConvertCommand.LOG_CLI.error("File does already exist: {}", (Object)file);
                    this.returnCode = 1;
                }
                ConvertCommand.LOG_CLI.info("Created {}", (Object)file);
                try (FileWriter fw2 = new FileWriter(file);){
                    this.converter.printXml(modelInstance.getValue().getDocument(), true, fw2);
                    fw2.flush();
                }
                catch (IOException e) {
                    ConvertCommand.LOG_CLI.error("Error while creating BPMN file: {}", (Object)this.createMessage(e));
                    this.returnCode = 1;
                }
            }
        }
        if (this.csv) {
            File csvFile = this.determineFileName(new File(this.targetDirectory(), "conversion-results.csv"));
            try {
                fw = new FileWriter(csvFile);
                try {
                    this.converter.writeCsvFile(results, fw);
                    ConvertCommand.LOG_CLI.info("Created {}", (Object)csvFile);
                }
                finally {
                    fw.close();
                }
            }
            catch (IOException e) {
                ConvertCommand.LOG_CLI.error("Error while creating csv results: {}", (Object)this.createMessage(e));
                this.returnCode = 1;
            }
        }
        if (this.markdown) {
            File markdownFile = this.determineFileName(new File(this.targetDirectory(), "conversion-results.md"));
            try {
                fw = new FileWriter(markdownFile);
                try {
                    this.converter.writeMarkdownFile(results, fw);
                    ConvertCommand.LOG_CLI.info("Created {}", (Object)markdownFile);
                }
                finally {
                    fw.close();
                }
            }
            catch (IOException e) {
                ConvertCommand.LOG_CLI.error("Error while creating markdown results: {}", (Object)this.createMessage(e));
                this.returnCode = 1;
            }
        }
    }

    protected abstract File targetDirectory();

    private List<BpmnDiagramCheckResult> checkModels(Map<File, BpmnModelInstance> modelInstances) {
        return modelInstances.entrySet().stream().map(this::checkModel).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private BpmnDiagramCheckResult checkModel(Map.Entry<File, BpmnModelInstance> modelInstance) {
        try {
            return this.converter.check(modelInstance.getKey().getPath(), modelInstance.getValue(), ConverterPropertiesFactory.getInstance().merge(this.converterProperties()));
        }
        catch (Exception e) {
            ConvertCommand.LOG_CLI.error("Problem while converting: {}", (Object)this.createMessage(e));
            this.returnCode = 1;
            return null;
        }
    }

    protected abstract Map<File, BpmnModelInstance> modelInstances();

    protected DefaultConverterProperties converterProperties() {
        DefaultConverterProperties properties = new DefaultConverterProperties();
        properties.setDefaultJobType(this.defaultJobType);
        properties.setPlatformVersion(this.platformVersion);
        properties.setDefaultJobTypeEnabled(!this.defaultJobTypeDisabled);
        properties.setAppendDocumentation(this.documentation);
        properties.setAppendElements(!this.disableAppendElements);
        properties.setUseDelegateExpressionAsJobType(this.delegateExecutionAsJobType);
        return properties;
    }

    private File prefixFileName(File file) {
        return new File(file.getParentFile(), this.prefix + file.getName());
    }

    private File determineFileName(File file) {
        File newFile = file;
        int counter = 0;
        while (!this.override && newFile.exists()) {
            newFile = new File(file.getParentFile(), FilenameUtils.getBaseName(file.getName()) + " (" + ++counter + ")." + FilenameUtils.getExtension(file.getName()));
        }
        return newFile;
    }

    protected String createMessage(Exception e) {
        StringBuilder message = new StringBuilder(e.getMessage());
        for (Throwable ex = e.getCause(); ex != null; ex = ex.getCause()) {
            message.append(",").append("\n").append("caused by: ").append(ex.getMessage());
        }
        return message.toString();
    }
}

