/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor;

import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.message.Message;
import org.camunda.community.migration.converter.visitor.AbstractCamundaElementVisitor;

public abstract class AbstractListenerVisitor
extends AbstractCamundaElementVisitor {
    @Override
    protected final Message visitCamundaElement(DomElementVisitorContext context) {
        ListenerImplementation implementation = this.findListenerImplementation(context);
        String event = context.getElement().getAttribute("http://camunda.org/schema/1.0/bpmn", "event");
        return this.visitListener(context, event, implementation);
    }

    protected abstract Message visitListener(DomElementVisitorContext var1, String var2, ListenerImplementation var3);

    private ListenerImplementation findListenerImplementation(DomElementVisitorContext context) {
        String listenerImplementation = context.getElement().getAttribute("delegateExpression");
        if (listenerImplementation != null) {
            return new ListenerImplementation.DelegateExpressionImplementation(listenerImplementation);
        }
        listenerImplementation = context.getElement().getAttribute("class");
        if (listenerImplementation != null) {
            return new ListenerImplementation.ClassImplementation(listenerImplementation);
        }
        listenerImplementation = context.getElement().getAttribute("expression");
        if (listenerImplementation != null) {
            return new ListenerImplementation.ExpressionImplementation(listenerImplementation);
        }
        if (context.getElement().getChildElementsByNameNs("http://camunda.org/schema/1.0/bpmn", "script") != null && !context.getElement().getChildElementsByNameNs("http://camunda.org/schema/1.0/bpmn", "script").isEmpty()) {
            listenerImplementation = context.getElement().getChildElementsByNameNs("http://camunda.org/schema/1.0/bpmn", "script").get(0).getAttribute("scriptFormat");
            return new ListenerImplementation.ScriptImplementation(listenerImplementation);
        }
        return new ListenerImplementation.NullImplementation();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ListenerImplementation {
        public String implementation();

        public record NullImplementation() implements ListenerImplementation
        {
            @Override
            public String implementation() {
                return null;
            }
        }

        public record ScriptImplementation(String implementation) implements ListenerImplementation
        {
        }

        public record ExpressionImplementation(String implementation) implements ListenerImplementation
        {
        }

        public record ClassImplementation(String implementation) implements ListenerImplementation
        {
        }

        public record DelegateExpressionImplementation(String implementation) implements ListenerImplementation
        {
        }
    }
}

