/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor.impl.element;

import java.util.regex.Matcher;
import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.convertible.AbstractExecutionListenerConvertible;
import org.camunda.community.migration.converter.message.Message;
import org.camunda.community.migration.converter.message.MessageFactory;
import org.camunda.community.migration.converter.version.SemanticVersion;
import org.camunda.community.migration.converter.visitor.AbstractDelegateImplementationVisitor;
import org.camunda.community.migration.converter.visitor.AbstractListenerVisitor;

public class ExecutionListenerVisitor
extends AbstractListenerVisitor {
    @Override
    public String localName() {
        return "executionListener";
    }

    @Override
    protected Message visitListener(DomElementVisitorContext context, String event, AbstractListenerVisitor.ListenerImplementation implementation) {
        if (this.isExecutionListenerSupported(SemanticVersion.parse(context.getProperties().getPlatformVersion()))) {
            AbstractExecutionListenerConvertible.ZeebeExecutionListener executionListener = new AbstractExecutionListenerConvertible.ZeebeExecutionListener();
            executionListener.setEventType(AbstractExecutionListenerConvertible.ZeebeExecutionListener.EventType.valueOf(event));
            if (implementation instanceof AbstractListenerVisitor.ListenerImplementation.DelegateExpressionImplementation) {
                Matcher matcher = AbstractDelegateImplementationVisitor.DELEGATE_NAME_EXTRACT.matcher(implementation.implementation());
                String delegateName = matcher.find() ? matcher.group(1) : implementation.implementation();
                executionListener.setListenerType(delegateName);
            } else {
                executionListener.setListenerType(implementation.implementation());
            }
            context.addConversion(AbstractExecutionListenerConvertible.class, c -> c.addZeebeExecutionListener(executionListener));
            return MessageFactory.executionListenerSupported(event, implementation.implementation());
        }
        return MessageFactory.executionListener(event, implementation.implementation());
    }

    private boolean isExecutionListenerSupported(SemanticVersion version) {
        return version.ordinal() >= SemanticVersion._8_6.ordinal();
    }

    @Override
    public boolean canBeTransformed(DomElementVisitorContext context) {
        return this.isExecutionListenerSupported(SemanticVersion.parse(context.getProperties().getPlatformVersion()));
    }
}

