/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.conversion;

import java.util.Set;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.BpmnElementFactory;
import org.camunda.community.migration.converter.conversion.AbstractTypedConversion;
import org.camunda.community.migration.converter.convertible.AbstractDataMapperConvertible;

public class DataMapperConversion
extends AbstractTypedConversion<AbstractDataMapperConvertible> {
    @Override
    protected Class<AbstractDataMapperConvertible> type() {
        return AbstractDataMapperConvertible.class;
    }

    @Override
    protected final void convertTyped(DomElement element, AbstractDataMapperConvertible convertible) {
        DomElement extensionElements = BpmnElementFactory.getExtensionElements(element);
        if (convertible.getZeebeIoMappings() != null && !convertible.getZeebeIoMappings().isEmpty()) {
            extensionElements.appendChild(this.createIoMappings(element.getDocument(), convertible.getZeebeIoMappings()));
        }
        if (convertible.getZeebeTaskHeaders() != null && !convertible.getZeebeTaskHeaders().isEmpty()) {
            extensionElements.appendChild(this.createTaskHeaders(element.getDocument(), convertible.getZeebeTaskHeaders()));
        }
    }

    private DomElement createTaskHeaders(DomDocument document, Set<AbstractDataMapperConvertible.ZeebeTaskHeader> zeebeTaskHeaders) {
        DomElement taskHeaders = document.createElement("http://camunda.org/schema/zeebe/1.0", "taskHeaders");
        zeebeTaskHeaders.forEach(zeebeTaskHeader -> taskHeaders.appendChild(this.createTaskHeader((AbstractDataMapperConvertible.ZeebeTaskHeader)zeebeTaskHeader, document)));
        return taskHeaders;
    }

    private DomElement createTaskHeader(AbstractDataMapperConvertible.ZeebeTaskHeader zeebeTaskHeader, DomDocument document) {
        DomElement taskHeader = document.createElement("http://camunda.org/schema/zeebe/1.0", "header");
        taskHeader.setAttribute("key", zeebeTaskHeader.getKey());
        taskHeader.setAttribute("value", zeebeTaskHeader.getValue());
        return taskHeader;
    }

    private DomElement createIoMappings(DomDocument document, Set<AbstractDataMapperConvertible.ZeebeIoMapping> zeebeIoMappings) {
        DomElement mappings = document.createElement("http://camunda.org/schema/zeebe/1.0", "ioMapping");
        zeebeIoMappings.forEach(zeebeIoMapping -> mappings.appendChild(this.createIoMapping((AbstractDataMapperConvertible.ZeebeIoMapping)zeebeIoMapping, document)));
        return mappings;
    }

    private DomElement createIoMapping(AbstractDataMapperConvertible.ZeebeIoMapping zeebeIoMapping, DomDocument document) {
        DomElement mapping = document.createElement("http://camunda.org/schema/zeebe/1.0", zeebeIoMapping.getDirection().name().toLowerCase());
        mapping.setAttribute("source", zeebeIoMapping.getSource());
        mapping.setAttribute("target", zeebeIoMapping.getTarget());
        return mapping;
    }
}

