/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter;

import java.util.Comparator;
import java.util.List;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.BpmnDiagramCheckResult;
import org.camunda.community.migration.converter.BpmnElementFactory;

public class ConversionElementAppender {
    public void appendMessages(DomElement element, List<BpmnDiagramCheckResult.BpmnElementCheckMessage> messages) {
        if (!messages.isEmpty()) {
            DomElement extensionElements = BpmnElementFactory.getExtensionElements(element);
            messages.sort(Comparator.comparingInt(message -> message.getSeverity().ordinal()));
            messages.forEach(message -> extensionElements.appendChild(this.createMessage((BpmnDiagramCheckResult.BpmnElementCheckMessage)message, element.getDocument())));
        }
    }

    public void appendDocumentation(DomElement element, List<BpmnDiagramCheckResult.BpmnElementCheckMessage> messages) {
        DomElement documentation = BpmnElementFactory.getDocumentation(element);
        documentation.setTextContent(this.createDocumentation(documentation.getTextContent(), messages));
    }

    public void appendReferences(DomElement element, List<String> references) {
        if (!references.isEmpty()) {
            DomElement extensionElements = BpmnElementFactory.getExtensionElements(element);
            references.forEach(reference -> extensionElements.appendChild(this.createReference((String)reference, element.getDocument())));
        }
    }

    public void appendReferencedBy(DomElement element, List<String> referencedBys) {
        if (!referencedBys.isEmpty()) {
            DomElement extensionElements = BpmnElementFactory.getExtensionElements(element);
            referencedBys.forEach(referencedBy -> extensionElements.appendChild(this.createReferencedBy((String)referencedBy, element.getDocument())));
        }
    }

    private String createDocumentation(String currentDocumentation, List<BpmnDiagramCheckResult.BpmnElementCheckMessage> messages) {
        StringBuilder documentation = new StringBuilder(currentDocumentation == null ? "" : currentDocumentation);
        if (currentDocumentation != null && currentDocumentation.trim().length() > 0) {
            documentation.append("\n\n");
        }
        messages.forEach(message -> documentation.append(this.formatMessage((BpmnDiagramCheckResult.BpmnElementCheckMessage)message)));
        return documentation.toString();
    }

    private String formatMessage(BpmnDiagramCheckResult.BpmnElementCheckMessage message) {
        return "- " + String.valueOf((Object)message.getSeverity()) + ": " + message.getMessage() + "\n";
    }

    private DomElement createMessage(BpmnDiagramCheckResult.BpmnElementCheckMessage message, DomDocument document) {
        DomElement messageElement = document.createElement("http://camunda.org/schema/conversion/1.0", "message");
        messageElement.setAttribute("severity", message.getSeverity().name());
        if (message.getLink() != null) {
            messageElement.setAttribute("link", message.getLink());
        }
        messageElement.setTextContent(message.getMessage());
        return messageElement;
    }

    private DomElement createReference(String reference, DomDocument document) {
        DomElement referenceElement = document.createElement("http://camunda.org/schema/conversion/1.0", "reference");
        referenceElement.setTextContent(reference);
        return referenceElement;
    }

    private DomElement createReferencedBy(String referencedBy, DomDocument document) {
        DomElement referenceElement = document.createElement("http://camunda.org/schema/conversion/1.0", "referencedBy");
        referenceElement.setTextContent(referencedBy);
        return referenceElement;
    }
}

