/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.BpmnDiagramCheckContext;
import org.camunda.community.migration.converter.BpmnDiagramCheckResult;
import org.camunda.community.migration.converter.ConverterProperties;
import org.camunda.community.migration.converter.NotificationService;
import org.camunda.community.migration.converter.convertible.Convertible;
import org.camunda.community.migration.converter.message.EmptyMessage;
import org.camunda.community.migration.converter.message.Message;

public interface DomElementVisitorContext {
    public DomElement getElement();

    public void addElementToRemove();

    public void addAttributeToRemove(String var1, String var2);

    public void addMessage(Message var1);

    public void setAsBpmnProcessElement(Convertible var1);

    public <T extends Convertible> void addConversion(Class<T> var1, Consumer<T> var2);

    public void notify(Object var1);

    public ConverterProperties getProperties();

    public void references(String var1);

    public static class DefaultDomElementVisitorContext
    implements DomElementVisitorContext {
        private final DomElement element;
        private final BpmnDiagramCheckContext context;
        private final BpmnDiagramCheckResult result;
        private final NotificationService notificationService;
        private final ConverterProperties converterProperties;

        public DefaultDomElementVisitorContext(DomElement element, BpmnDiagramCheckContext context, BpmnDiagramCheckResult result, NotificationService notificationService, ConverterProperties converterProperties) {
            this.element = element;
            this.context = context;
            this.result = result;
            this.notificationService = notificationService;
            this.converterProperties = converterProperties;
        }

        @Override
        public DomElement getElement() {
            return this.element;
        }

        @Override
        public void addElementToRemove() {
            this.context.getElementsToRemove().add(this.element);
        }

        @Override
        public void addAttributeToRemove(String attributeLocalName, String namespaceUri) {
            this.context.addAttributeToRemove(this.element, namespaceUri, attributeLocalName);
        }

        @Override
        public void addMessage(Message message) {
            this.addMessage(this.element, message);
        }

        @Override
        public void setAsBpmnProcessElement(Convertible convertible) {
            this.createBpmnElementCheckResult(this.element, convertible);
        }

        @Override
        public <T extends Convertible> void addConversion(Class<T> convertibleType, Consumer<T> operation) {
            this.addConversion(this.element, convertibleType, operation);
        }

        @Override
        public void notify(Object object) {
            this.notificationService.notify(object);
        }

        @Override
        public ConverterProperties getProperties() {
            return this.converterProperties;
        }

        @Override
        public void references(String referencedElementId) {
            this.references(this.element, referencedElementId);
        }

        private void references(DomElement element, String referencedElementId) {
            BpmnDiagramCheckResult.BpmnElementCheckResult currentElementCheckResult = this.findBpmnElementCheckResult(element);
            BpmnDiagramCheckResult.BpmnElementCheckResult referencedResult = this.result.getResult(referencedElementId);
            if (referencedResult != null) {
                this.createReference(currentElementCheckResult, referencedResult);
            } else {
                this.context.getReferencesToCreate().computeIfAbsent(referencedElementId, s -> new ArrayList()).add(currentElementCheckResult);
            }
        }

        private void createReference(BpmnDiagramCheckResult.BpmnElementCheckResult references, BpmnDiagramCheckResult.BpmnElementCheckResult referencedBy) {
            references.getReferences().add(referencedBy.getElementId());
            referencedBy.getReferencedBy().add(references.getElementId());
        }

        private void addMessage(DomElement element, Message message) {
            if (!(message instanceof EmptyMessage)) {
                this.findElementMessages(element).add(this.createMessage(message));
            }
        }

        private BpmnDiagramCheckResult.BpmnElementCheckMessage createMessage(Message message) {
            BpmnDiagramCheckResult.BpmnElementCheckMessage m = new BpmnDiagramCheckResult.BpmnElementCheckMessage();
            m.setMessage(message.getMessage());
            m.setSeverity(message.getSeverity());
            m.setLink(message.getLink());
            m.setId(message.getId());
            return m;
        }

        private List<BpmnDiagramCheckResult.BpmnElementCheckMessage> findElementMessages(DomElement element) {
            return this.findBpmnElementCheckResult(element).getMessages();
        }

        private <T extends Convertible> void addConversion(DomElement element, Class<T> type, Consumer<T> modifier) {
            T conversion = this.findConvertible(element, type);
            modifier.accept(conversion);
        }

        private <T extends Convertible> T findConvertible(DomElement element, Class<T> type) {
            if (this.context.getConvertibles().containsKey(element)) {
                return (T)((Convertible)type.cast(this.context.getConvertibles().get(element)));
            }
            return this.findConvertible(element.getParentElement(), type);
        }

        private BpmnDiagramCheckResult.BpmnElementCheckResult findBpmnElementCheckResult(DomElement element) {
            return this.result.getResults().stream().filter(r -> r.getElementId().equals(this.extractId(element))).findFirst().orElseGet(() -> this.findBpmnElementCheckResult(element.getParentElement()));
        }

        private String extractId(DomElement element) {
            return element.getAttribute("id");
        }

        private void createBpmnElementCheckResult(DomElement element, Convertible convertible) {
            String id = this.extractId(element);
            Objects.requireNonNull(id);
            if (this.containsId(id)) {
                throw new IllegalStateException("Element with id '" + id + "' is already contained in list of results");
            }
            BpmnDiagramCheckResult.BpmnElementCheckResult result = new BpmnDiagramCheckResult.BpmnElementCheckResult();
            this.context.addConvertible(element, convertible);
            result.setElementId(id);
            result.setElementName(element.getAttribute("name"));
            result.setElementType(element.getLocalName());
            List bpmnElementCheckResults = this.context.getReferencesToCreate().getOrDefault(id, new ArrayList());
            bpmnElementCheckResults.forEach(other -> this.createReference((BpmnDiagramCheckResult.BpmnElementCheckResult)other, result));
            this.result.getResults().add(result);
        }

        private boolean containsId(String id) {
            return this.result.getResults().stream().anyMatch(r -> r.getElementId().equals(id));
        }
    }
}

