/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.expression;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.camunda.community.migration.converter.expression.ExpressionTransformationResult;

public class ExpressionTransformer {
    private static final ExpressionTransformer INSTANCE = new ExpressionTransformer();

    private ExpressionTransformer() {
    }

    public static ExpressionTransformationResult transform(String juelExpression) {
        if (juelExpression == null) {
            return null;
        }
        String transform = INSTANCE.doTransform(juelExpression);
        return new ExpressionTransformationResult(juelExpression, transform);
    }

    private String doTransform(String juelExpression) {
        if (juelExpression == null) {
            return null;
        }
        if (juelExpression.isEmpty()) {
            return "=null";
        }
        List<String> nonExpressions = Arrays.stream(juelExpression.split("(#|\\$)\\{.*}")).map(String::trim).filter(s -> !s.isEmpty()).toList();
        if (nonExpressions.size() == 1 && juelExpression.trim().length() == nonExpressions.get(0).length()) {
            return juelExpression;
        }
        List expressions = Arrays.stream(juelExpression.split("(#|\\$)\\{|}")).map(String::trim).filter(s -> !s.isEmpty()).map(s -> nonExpressions.contains(s) ? "\"" + s + "\"" : this.handleExpression((String)s)).collect(Collectors.toList());
        return "=" + String.join((CharSequence)" + ", expressions);
    }

    private String handleExpression(String expression) {
        String replaced = expression.replaceAll("empty (\\S*)", "$1=null").replaceAll("!(?![\\(=])([\\S-^]*)", "not($1)").replaceAll("not (?![\\(=])([\\S-^]*)", "not($1)").replaceAll("\\[\\\"(\\D[^\\]\\[]*)\\\"]", ".$1").replaceAll(" gt ", " > ").replaceAll(" lt ", " < ").replaceAll("==", "=").replaceAll(" eq ", " = ").replaceAll(" ne ", " != ").replaceAll("!\\(([^\\(\\)]*)\\)", "not($1)").replaceAll(" && ", " and ").replaceAll(" \\|\\| ", " or ").replaceAll("'", "\"").replaceAll("execution\\.getVariable\\(\"(.*)\"\\)", "$1");
        Pattern pattern = Pattern.compile("\\[(\\d*)\\]");
        Matcher m = pattern.matcher(replaced);
        while (m.find()) {
            String oldIndex = "[" + Long.parseLong(m.group(1)) + "]";
            String newIndex = "[" + (Long.parseLong(m.group(1)) + 1L) + "]";
            replaced = replaced.replace(oldIndex, newIndex);
        }
        return replaced;
    }
}

