/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter;

import java.util.ArrayList;
import java.util.List;

public class DiagramCheckResult {
    private final List<ElementCheckResult> results = new ArrayList<ElementCheckResult>();
    private String filename;
    private String converterVersion;

    public String getConverterVersion() {
        return this.converterVersion;
    }

    public void setConverterVersion(String converterVersion) {
        this.converterVersion = converterVersion;
    }

    public List<ElementCheckResult> getResults() {
        return this.results;
    }

    public ElementCheckResult getResult(String elementId) {
        return this.getResults().stream().filter(element -> element.getElementId().equals(elementId)).findFirst().orElse(null);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String toString() {
        return "DiagramCheckResult{results=" + String.valueOf(this.results) + ", filename='" + this.filename + "'}";
    }

    public static class ElementCheckResult {
        private final List<ElementCheckMessage> messages = new ArrayList<ElementCheckMessage>();
        private final List<String> references = new ArrayList<String>();
        private final List<String> referencedBy = new ArrayList<String>();
        private String elementId;
        private String elementName;
        private String elementType;

        public List<ElementCheckMessage> getMessages() {
            return this.messages;
        }

        public String getElementId() {
            return this.elementId;
        }

        public void setElementId(String elementId) {
            this.elementId = elementId;
        }

        public String getElementName() {
            return this.elementName;
        }

        public void setElementName(String elementName) {
            this.elementName = elementName;
        }

        public String getElementType() {
            return this.elementType;
        }

        public void setElementType(String elementType) {
            this.elementType = elementType;
        }

        public List<String> getReferences() {
            return this.references;
        }

        public List<String> getReferencedBy() {
            return this.referencedBy;
        }

        public String toString() {
            return "ElementCheckResult{messages=" + String.valueOf(this.messages) + ", references=" + String.valueOf(this.references) + ", referencedBy=" + String.valueOf(this.referencedBy) + ", elementId='" + this.elementId + "', elementName='" + this.elementName + "', elementType='" + this.elementType + "'}";
        }
    }

    public static class ElementCheckMessage {
        private Severity severity;
        private String message;
        private String link;
        private String id;

        public Severity getSeverity() {
            return this.severity;
        }

        public void setSeverity(Severity severity) {
            this.severity = severity;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String toString() {
            return "ElementCheckMessage{severity=" + String.valueOf((Object)this.severity) + ", message='" + this.message + "', link='" + this.link + "', id='" + this.id + "'}";
        }
    }

    public static enum Severity {
        WARNING,
        TASK,
        REVIEW,
        INFO;

    }
}

