/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter;

import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVWriter;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.camunda.bpm.model.bpmn.impl.BpmnParser;
import org.camunda.bpm.model.dmn.impl.DmnParser;
import org.camunda.bpm.model.xml.ModelInstance;
import org.camunda.bpm.model.xml.impl.parser.AbstractModelParser;
import org.camunda.bpm.model.xml.impl.util.ModelIoException;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.ConversionElementAppender;
import org.camunda.community.migration.converter.ConverterProperties;
import org.camunda.community.migration.converter.DiagramCheckContext;
import org.camunda.community.migration.converter.DiagramCheckResult;
import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.NamespaceUri;
import org.camunda.community.migration.converter.NotificationService;
import org.camunda.community.migration.converter.conversion.Conversion;
import org.camunda.community.migration.converter.convertible.Convertible;
import org.camunda.community.migration.converter.visitor.AbstractDmnElementVisitor;
import org.camunda.community.migration.converter.visitor.AbstractProcessElementVisitor;
import org.camunda.community.migration.converter.visitor.DomElementVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagramConverter {
    private static final Logger LOG = LoggerFactory.getLogger(DiagramConverter.class);
    private static final Template MARKDOWN_TEMPLATE;
    private final List<DomElementVisitor> visitors;
    private final List<Conversion> conversions;
    private final NotificationService notificationService;

    public DiagramConverter(List<DomElementVisitor> visitors, List<Conversion> conversions, NotificationService notificationService) {
        this.visitors = visitors;
        this.conversions = conversions;
        this.notificationService = notificationService;
    }

    public void convert(ModelInstance modelInstance, ConverterProperties properties) {
        this.check(null, modelInstance, properties);
    }

    public DiagramCheckResult check(String filename, ModelInstance modelInstance, ConverterProperties converterProperties) {
        return this.check(filename, modelInstance.getDocument().getRootElement(), converterProperties);
    }

    private DiagramCheckResult check(String filename, DomElement rootElement, ConverterProperties properties) {
        LOG.info("Start check");
        DiagramCheckResult result = new DiagramCheckResult();
        result.setFilename(filename);
        result.setConverterVersion(this.getClass().getPackage().getImplementationVersion());
        DiagramCheckContext context = new DiagramCheckContext();
        this.traverse(rootElement, result, context, properties);
        LOG.info("Done check");
        LOG.info("Start remove of old elements");
        context.getElementsToRemove().forEach(element -> element.getParentElement().removeChild((DomElement)element));
        context.getAttributesToRemove().forEach((element, stringSetMap) -> stringSetMap.forEach((namespaceUri, attributes) -> attributes.forEach(attribute -> element.removeAttribute((String)namespaceUri, (String)attribute))));
        LOG.info("Done remove of old elements");
        LOG.info("Start conversion");
        ConversionElementAppender conversionElementAppender = new ConversionElementAppender();
        context.getConvertibles().forEach((element, convertible) -> {
            List<DiagramCheckResult.ElementCheckMessage> messages = this.getMessages((DomElement)element, result);
            List<String> references = this.getReferences((DomElement)element, result);
            List<String> referencedBys = this.getReferencedBys((DomElement)element, result);
            if (properties.getAppendElements().booleanValue()) {
                conversionElementAppender.appendMessages((DomElement)element, messages);
                conversionElementAppender.appendReferences((DomElement)element, references);
                conversionElementAppender.appendReferencedBy((DomElement)element, referencedBys);
            }
            if (properties.getAppendDocumentation().booleanValue()) {
                conversionElementAppender.appendDocumentation((DomElement)element, this.collectMessages(result, messages, references));
            }
            this.conversions.forEach(conversion -> conversion.convert((DomElement)element, (Convertible)convertible, messages));
        });
        LOG.info("Done with conversion");
        return result;
    }

    private List<DiagramCheckResult.ElementCheckMessage> collectMessages(DiagramCheckResult result, List<DiagramCheckResult.ElementCheckMessage> messages, List<String> references) {
        ArrayList<DiagramCheckResult.ElementCheckMessage> collectedMessages = new ArrayList<DiagramCheckResult.ElementCheckMessage>();
        collectedMessages.addAll(messages);
        collectedMessages.addAll(references.stream().flatMap(reference -> this.getMessages((String)reference, result).stream()).collect(Collectors.toList()));
        return collectedMessages;
    }

    private List<DiagramCheckResult.ElementCheckMessage> getMessages(DomElement element, DiagramCheckResult result) {
        return result.getResults().stream().filter(elementCheckResult -> elementCheckResult.getElementId().equals(element.getAttribute("id"))).map(DiagramCheckResult.ElementCheckResult::getMessages).findFirst().orElseGet(ArrayList::new);
    }

    private List<DiagramCheckResult.ElementCheckMessage> getMessages(String elementId, DiagramCheckResult result) {
        return result.getResults().stream().filter(elementCheckResult -> elementCheckResult.getElementId().equals(elementId)).map(DiagramCheckResult.ElementCheckResult::getMessages).findFirst().orElseGet(ArrayList::new);
    }

    private List<String> getReferences(DomElement element, DiagramCheckResult result) {
        return result.getResults().stream().filter(elementCheckResult -> elementCheckResult.getElementId().equals(element.getAttribute("id"))).map(DiagramCheckResult.ElementCheckResult::getReferences).findFirst().orElseGet(ArrayList::new);
    }

    private List<String> getReferencedBys(DomElement element, DiagramCheckResult result) {
        return result.getResults().stream().filter(elementCheckResult -> elementCheckResult.getElementId().equals(element.getAttribute("id"))).map(DiagramCheckResult.ElementCheckResult::getReferencedBy).findFirst().orElseGet(ArrayList::new);
    }

    private AbstractModelParser getParser(DomDocument document) {
        if (document.getRootElement().getNamespaceURI().equals("http://www.omg.org/spec/BPMN/20100524/MODEL")) {
            return new BpmnParser();
        }
        if (Arrays.asList(NamespaceUri.DMN).contains(document.getRootElement().getNamespaceURI())) {
            return new DmnParser();
        }
        throw new IllegalArgumentException("Unknown document namespace: " + document.getRootElement().getNamespaceURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printXml(DomDocument document, boolean prettyPrint, Writer writer) {
        this.getParser(document).validateModel(document);
        StreamResult result = new StreamResult(writer);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("prettyprint.xsl");){
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(new InputStreamReader(in)));
            transformer.setOutputProperty("encoding", "UTF-8");
            if (prettyPrint) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            DomDocument domDocument = document;
            synchronized (domDocument) {
                transformer.transform(document.getDomSource(), result);
            }
        }
        catch (TransformerConfigurationException e) {
            throw new ModelIoException("Unable to create a transformer for the model", e);
        }
        catch (TransformerException e) {
            throw new ModelIoException("Unable to transform model to xml", e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void traverse(DomElement element, DiagramCheckResult result, DiagramCheckContext context, ConverterProperties properties) {
        DomElementVisitorContext.DefaultDomElementVisitorContext elementContext = new DomElementVisitorContext.DefaultDomElementVisitorContext(element, context, result, this.notificationService, properties);
        this.visitors.stream().sorted(Comparator.comparingInt(this::sortVisitor)).forEach(visitor -> visitor.visit(elementContext));
        element.getChildElements().forEach(child -> this.traverse((DomElement)child, result, context, properties));
    }

    private int sortVisitor(DomElementVisitor visitor) {
        if (visitor instanceof AbstractProcessElementVisitor) {
            return 2;
        }
        if (visitor instanceof AbstractDmnElementVisitor) {
            return 2;
        }
        if (visitor.getClass().getPackageName().startsWith(DomElementVisitor.class.getPackage().getName())) {
            return 3;
        }
        return 4;
    }

    public void writeCsvFile(List<DiagramCheckResult> results, Writer writer) {
        try (ICSVWriter csvWriter = new CSVWriterBuilder(writer).withSeparator(';').build();){
            csvWriter.writeNext(this.createHeaders());
            csvWriter.writeAll(this.createLines(results));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing csv file", e);
        }
    }

    public void writeMarkdownFile(List<DiagramCheckResult> results, Writer writer) {
        MARKDOWN_TEMPLATE.execute(this.createContext(results), writer);
    }

    private MustacheContext createContext(List<DiagramCheckResult> results) {
        ArrayList<MustacheContext.MustacheResultContext> contexts = new ArrayList<MustacheContext.MustacheResultContext>();
        results.forEach(bpmnDiagramCheckResult -> {
            ArrayList<MustacheContext.MustacheResultContext.MustacheElementResultContext> resultList = new ArrayList<MustacheContext.MustacheResultContext.MustacheElementResultContext>();
            bpmnDiagramCheckResult.getResults().forEach(bpmnElementCheckResult -> {
                ArrayList<MustacheContext.MustacheResultContext.MustacheElementResultContext.MustacheSeverityContext> severities = new ArrayList<MustacheContext.MustacheResultContext.MustacheElementResultContext.MustacheSeverityContext>();
                bpmnElementCheckResult.getMessages().forEach(bpmnElementCheckMessage -> {
                    MustacheContext.MustacheResultContext.MustacheElementResultContext.MustacheSeverityContext mustacheSeverityContext = severities.stream().filter(severity -> severity.severity().equals(bpmnElementCheckMessage.getSeverity().name())).findFirst().orElseGet(() -> {
                        ArrayList<MustacheContext.MustacheResultContext.MustacheElementResultContext.MustacheSeverityContext.MustacheMessageContext> messages = new ArrayList<MustacheContext.MustacheResultContext.MustacheElementResultContext.MustacheSeverityContext.MustacheMessageContext>();
                        MustacheContext.MustacheResultContext.MustacheElementResultContext.MustacheSeverityContext newMustacheSeverityContext = new MustacheContext.MustacheResultContext.MustacheElementResultContext.MustacheSeverityContext(bpmnElementCheckMessage.getSeverity().name(), messages, (frag, out) -> out.write(String.valueOf(messages.size())));
                        severities.add(newMustacheSeverityContext);
                        return newMustacheSeverityContext;
                    });
                    mustacheSeverityContext.messages().add(new MustacheContext.MustacheResultContext.MustacheElementResultContext.MustacheSeverityContext.MustacheMessageContext(bpmnElementCheckMessage.getMessage(), bpmnElementCheckMessage.getLink()));
                });
                resultList.add(new MustacheContext.MustacheResultContext.MustacheElementResultContext(bpmnElementCheckResult.getElementName(), bpmnElementCheckResult.getElementId(), bpmnElementCheckResult.getElementType(), severities));
            });
            contexts.add(new MustacheContext.MustacheResultContext(bpmnDiagramCheckResult.getFilename(), resultList));
        });
        return new MustacheContext(contexts);
    }

    private String[] createHeaders() {
        return new String[]{"filename", "elementName", "elementId", "elementType", "severity", "messageId", "message", "link"};
    }

    private List<String[]> createLines(List<DiagramCheckResult> results) {
        return results.stream().flatMap(diagramCheckResult -> diagramCheckResult.getResults().stream().flatMap(elementCheckResult -> elementCheckResult.getMessages().stream().map(message -> new String[]{diagramCheckResult.getFilename(), elementCheckResult.getElementName(), elementCheckResult.getElementId(), elementCheckResult.getElementType(), message.getSeverity().name(), message.getId(), message.getMessage(), message.getLink()}))).collect(Collectors.toList());
    }

    static {
        try (InputStream in = DiagramConverter.class.getClassLoader().getResourceAsStream("bpmn-diagram-check-result.mustache");){
            MARKDOWN_TEMPLATE = Mustache.compiler().compile(new String(in.readAllBytes()));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while loading result printer template", e);
        }
    }

    record MustacheContext(List<MustacheResultContext> contexts) {

        record MustacheResultContext(String filename, List<MustacheElementResultContext> results) {

            record MustacheElementResultContext(String elementName, String elementId, String elementType, List<MustacheSeverityContext> severities) {

                record MustacheSeverityContext(String severity, List<MustacheMessageContext> messages, Mustache.Lambda count) {

                    record MustacheMessageContext(String message, String link) {
                    }
                }
            }
        }
    }
}

