/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.cli;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.file.PathVisitor;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.community.migration.converter.cli.AbstractConvertCommand;
import org.camunda.community.migration.converter.cli.ConvertCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="local", description={"Converts the diagram from the given directory or file", "%nExecute as:", "%njava -Dfile.encoding=UTF-8 -jar backend-diagram-converter-cli.jar local%n"}, mixinStandardHelpOptions=true, optionListHeading="Options:%n", parameterListHeading="Parameter:%n", showDefaultValues=true)
public class ConvertLocalCommand
extends AbstractConvertCommand {
    private static final String[] FILE_ENDINGS = new String[]{"bpmn", "bpmn20.xml"};
    @CommandLine.Parameters(index="0", description={"The file to convert or directory to search in"})
    File file;
    @CommandLine.Option(names={"-nr", "--not-recursive"}, description={"If enabled, recursive search in subfolders will be omitted"})
    boolean notRecursive;

    @Override
    protected File targetDirectory() {
        if (this.file.isDirectory()) {
            return this.file;
        }
        return this.file.getParentFile();
    }

    @Override
    protected Map<File, BpmnModelInstance> modelInstances() {
        if (!this.file.exists()) {
            ConvertCommand.LOG_CLI.error("File {} does not exist", (Object)this.file.getAbsolutePath());
            this.returnCode = 1;
            return new HashMap<File, BpmnModelInstance>();
        }
        ArrayList<File> files = new ArrayList<File>();
        if (this.file.isDirectory()) {
            files.addAll(this.findFiles(this.file));
        } else if (this.isBpmnFile(this.file)) {
            files.add(this.file);
        } else {
            ConvertCommand.LOG_CLI.error("The selected file is no bpmn file");
            throw new IllegalArgumentException("The selected file is no bpmn file");
        }
        return this.handleFiles(files);
    }

    private Map<File, BpmnModelInstance> handleFiles(Collection<File> files) {
        return files.stream().filter(this::canHandleFile).collect(Collectors.toMap(f -> f, this::handleFile));
    }

    private boolean canHandleFile(File file) {
        try {
            this.handleFile(file);
            return true;
        }
        catch (Exception e) {
            ConvertCommand.LOG_CLI.error("Unable to parse file {}, reason is: {}", (Object)file.getAbsolutePath(), (Object)this.createMessage(e));
            return false;
        }
    }

    private BpmnModelInstance handleFile(File file) {
        return Bpmn.readModelFromFile(file);
    }

    private boolean isBpmnFile(File file) {
        return Arrays.stream(FILE_ENDINGS).anyMatch(ending -> file.getName().endsWith((String)ending));
    }

    private List<File> findFiles(File directory) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            Files.walkFileTree(directory.toPath(), new FindFileBySuffixPathVisitor(files, Arrays.asList(FILE_ENDINGS)));
        }
        catch (Exception e) {
            ConvertCommand.LOG_CLI.error("Error while finding files: {}", (Object)this.createMessage(e));
            this.returnCode = 1;
        }
        return files;
    }

    public static class FindFileBySuffixPathVisitor
    implements PathVisitor {
        private static final Logger LOG = LoggerFactory.getLogger(FindFileBySuffixPathVisitor.class);
        private final List<File> files;
        private final List<String> suffixes;

        public FindFileBySuffixPathVisitor(List<File> files, List<String> suffixes) {
            this.files = files;
            this.suffixes = suffixes;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            LOG.debug("Start visiting directory '{}'", (Object)dir.toFile().getAbsolutePath());
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.suffixes.stream().anyMatch(suffix -> file.toFile().getName().endsWith((String)suffix))) {
                this.files.add(file.toFile());
                LOG.debug("Visited file, added '{}'", (Object)file.toFile().getAbsolutePath());
            } else {
                LOG.debug("Visited file, not added '{}'", (Object)file.toFile().getAbsolutePath());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            LOG.debug("Visiting file failed '{}'", (Object)file.toFile().getAbsolutePath());
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            LOG.debug("Done visiting directory '{}'", (Object)dir.toFile().getAbsolutePath());
            return FileVisitResult.CONTINUE;
        }
    }
}

