/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.conversion;

import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.BpmnElementFactory;
import org.camunda.community.migration.converter.conversion.AbstractTypedConversion;
import org.camunda.community.migration.converter.convertible.CallActivityConvertible;

public class CallActivityConversion
extends AbstractTypedConversion<CallActivityConvertible> {
    private DomElement createCalledElement(DomDocument document, CallActivityConvertible convertible) {
        DomElement calledElement = document.createElement("http://camunda.org/schema/zeebe/1.0", "calledElement");
        if (convertible.getZeebeCalledElement().getProcessId() != null) {
            calledElement.setAttribute("http://camunda.org/schema/zeebe/1.0", "processId", convertible.getZeebeCalledElement().getProcessId());
        }
        if (convertible.getZeebeCalledElement().getBindingType() != null) {
            calledElement.setAttribute("http://camunda.org/schema/zeebe/1.0", "bindingType", convertible.getZeebeCalledElement().getBindingType().name());
        }
        if (StringUtils.isNotBlank(convertible.getZeebeCalledElement().getVersionTag())) {
            calledElement.setAttribute("http://camunda.org/schema/zeebe/1.0", "versionTag", convertible.getZeebeCalledElement().getVersionTag());
        }
        calledElement.setAttribute("propagateAllChildVariables", Boolean.toString(convertible.getZeebeCalledElement().isPropagateAllChildVariables()));
        calledElement.setAttribute("propagateAllParentVariables", Boolean.toString(convertible.getZeebeCalledElement().isPropagateAllParentVariables()));
        return calledElement;
    }

    @Override
    protected void convertTyped(DomElement element, CallActivityConvertible convertible) {
        DomElement extensionProperties = BpmnElementFactory.getExtensionElements(element);
        extensionProperties.appendChild(this.createCalledElement(element.getDocument(), convertible));
    }

    @Override
    protected Class<CallActivityConvertible> type() {
        return CallActivityConvertible.class;
    }
}

