/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.expression;

import java.util.Objects;
import org.camunda.community.migration.converter.expression.ExpressionTransformationResult;
import org.camunda.community.migration.converter.message.Message;
import org.camunda.community.migration.converter.message.MessageFactory;

public class ExpressionTransformationResultMessageFactory {
    public static Message getMessage(ExpressionTransformationResult transformationResult, String link) {
        if (Objects.equals(transformationResult.getFeelExpression(), transformationResult.getJuelExpression())) {
            return MessageFactory.noExpressionTransformation();
        }
        if (transformationResult.getHasExecutionOnly().booleanValue()) {
            return MessageFactory.expressionExecutionNotAvailable(transformationResult.getContext(), transformationResult.getJuelExpression(), transformationResult.getFeelExpression(), link);
        }
        if (transformationResult.getHasMethodInvocation().booleanValue()) {
            return MessageFactory.expressionMethodNotPossible(transformationResult.getContext(), transformationResult.getJuelExpression(), transformationResult.getFeelExpression(), link);
        }
        return MessageFactory.expression(transformationResult.getContext(), transformationResult.getJuelExpression(), transformationResult.getFeelExpression(), link);
    }
}

