/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.expression;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.camunda.community.migration.converter.expression.ExpressionTransformationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(ExpressionTransformer.class);
    private static final ExpressionTransformer INSTANCE = new ExpressionTransformer();
    private static final Pattern methodInvocationPattern = Pattern.compile("\\.[\\w]*\\(.*\\)");
    private static final Pattern executionPattern = Pattern.compile("execution\\.");
    private static final Pattern executionGetVariablePattern = Pattern.compile("execution.getVariable");

    private ExpressionTransformer() {
    }

    public static ExpressionTransformationResult transform(String context, String juelExpression) {
        if (juelExpression == null) {
            return null;
        }
        String transform = INSTANCE.doTransform(juelExpression, false);
        boolean hasMethodInvocation = INSTANCE.hasMethodInvocation(juelExpression);
        boolean hasExecutionOnly = INSTANCE.hasExecutionOnly(juelExpression);
        return new ExpressionTransformationResult(context, juelExpression, transform, hasMethodInvocation, hasExecutionOnly);
    }

    public static ExpressionTransformationResult transformDmn(String context, String juelExpression) {
        if (juelExpression == null) {
            return null;
        }
        String transform = INSTANCE.doTransform(juelExpression, true);
        boolean hasMethodInvocation = INSTANCE.hasMethodInvocation(juelExpression);
        boolean hasExecutionOnly = INSTANCE.hasExecutionOnly(juelExpression);
        return new ExpressionTransformationResult(context, juelExpression, transform, hasMethodInvocation, hasExecutionOnly);
    }

    private Boolean hasMethodInvocation(String juelExpression) {
        if (this.hasExecutionGetVariable(juelExpression).booleanValue()) {
            return false;
        }
        Matcher m = methodInvocationPattern.matcher(juelExpression);
        boolean methodMatch = m.find();
        LOG.debug("{} contains method invocation: {}", (Object)juelExpression, (Object)methodMatch);
        return methodMatch;
    }

    private Boolean hasExecutionOnly(String juelExpression) {
        if (this.hasExecutionGetVariable(juelExpression).booleanValue()) {
            return false;
        }
        Matcher m = executionPattern.matcher(juelExpression);
        boolean executionOnlyMatch = m.find();
        LOG.debug("{} contains execution only: {}", (Object)juelExpression, (Object)executionOnlyMatch);
        return executionOnlyMatch;
    }

    private Boolean hasExecutionGetVariable(String juelExpression) {
        Matcher m = executionGetVariablePattern.matcher(juelExpression);
        boolean executionGetVariableMatch = m.find();
        LOG.debug("{} contains execution.getVariable: {}", (Object)juelExpression, (Object)executionGetVariableMatch);
        return executionGetVariableMatch;
    }

    private String doTransform(String juelExpression, boolean dmnMode) {
        if (juelExpression == null) {
            return null;
        }
        if (juelExpression.isEmpty()) {
            return dmnMode ? null : "=null";
        }
        List<String> nonExpressions = Arrays.stream(juelExpression.split("(#|\\$)\\{.*}")).map(String::trim).filter(s -> !s.isEmpty()).toList();
        if (nonExpressions.size() == 1 && juelExpression.trim().length() == nonExpressions.get(0).length()) {
            return juelExpression;
        }
        List expressions = Arrays.stream(juelExpression.split("(#|\\$)\\{|}")).map(String::trim).filter(s -> !s.isEmpty()).map(s -> nonExpressions.contains(s) ? "\"" + s + "\"" : this.handleExpression((String)s)).collect(Collectors.toList());
        return (dmnMode ? "" : "=") + String.join((CharSequence)" + ", expressions);
    }

    private String handleExpression(String expression) {
        String replaced = expression.replaceAll("empty (\\S*)", "$1=null").replaceAll("!(?![\\(=])([\\S-^]*)", "not($1)").replaceAll("not (?![\\(=])([\\S-^]*)", "not($1)").replaceAll("\\[\\\"(\\D[^\\]\\[]*)\\\"]", ".$1").replaceAll(" gt ", " > ").replaceAll(" lt ", " < ").replaceAll("==", "=").replaceAll(" eq ", " = ").replaceAll(" ne ", " != ").replaceAll("!\\(([^\\(\\)]*)\\)", "not($1)").replaceAll(" && ", " and ").replaceAll(" \\|\\| ", " or ").replaceAll("'", "\"").replaceAll("execution\\.getVariable\\(\"(.*)\"\\)", "$1");
        Pattern pattern = Pattern.compile("\\[(\\d*)\\]");
        Matcher m = pattern.matcher(replaced);
        while (m.find()) {
            String oldIndex = "[" + Long.parseLong(m.group(1)) + "]";
            String newIndex = "[" + (Long.parseLong(m.group(1)) + 1L) + "]";
            replaced = replaced.replace(oldIndex, newIndex);
        }
        return replaced;
    }
}

