/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.version;

public enum SemanticVersion {
    _8_0("8.0"),
    _8_1("8.1"),
    _8_2("8.2"),
    _8_3("8.3"),
    _8_4("8.4"),
    _8_5("8.5"),
    _8_6("8.6");

    private final String name;

    private SemanticVersion(String name) {
        this.name = name;
    }

    public static SemanticVersion parse(String platformVersion) {
        platformVersion = (String)platformVersion + ".";
        for (SemanticVersion v : SemanticVersion.values()) {
            if (!((String)platformVersion).startsWith(v.toString() + ".")) continue;
            return v;
        }
        throw new IllegalStateException("Not a valid Platform version: " + (String)platformVersion);
    }

    public String toString() {
        return this.name;
    }

    public String getPatchZeroVersion() {
        return this.name + ".0";
    }
}

