/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor;

import java.util.Arrays;
import java.util.List;
import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.NamespaceUri;
import org.camunda.community.migration.converter.visitor.AbstractFilteringVisitor;

public abstract class AbstractAttributeVisitor
extends AbstractFilteringVisitor {
    @Override
    protected void visitFilteredElement(DomElementVisitorContext context) {
        Attribute attribute = this.resolveAttribute(context);
        this.visitAttribute(context, attribute.value());
        if (this.removeAttribute(context) && attribute.namespaceUri() != null) {
            context.addAttributeToRemove(this.attributeLocalName(), attribute.namespaceUri());
        }
    }

    private Attribute resolveAttribute(DomElementVisitorContext context) {
        for (String namespaceUri : this.namespaceUri()) {
            String attribute = context.getElement().getAttribute(namespaceUri, this.attributeLocalName());
            if (attribute == null) continue;
            return new Attribute(namespaceUri, this.attributeLocalName(), attribute);
        }
        return new Attribute(null, this.attributeLocalName(), null);
    }

    @Override
    protected boolean canVisit(DomElementVisitorContext context) {
        return this.resolveAttribute(context).value() != null && (context.getElement().getNamespaceURI().equals("http://www.omg.org/spec/BPMN/20100524/MODEL") || Arrays.asList(NamespaceUri.DMN).contains(context.getElement().getNamespaceURI()));
    }

    protected abstract List<String> namespaceUri();

    public abstract String attributeLocalName();

    protected abstract void visitAttribute(DomElementVisitorContext var1, String var2);

    protected abstract boolean removeAttribute(DomElementVisitorContext var1);

    @Override
    protected void logVisit(DomElementVisitorContext context) {
        this.LOG.debug("Visiting attribute 'camunda:{}' on element '{}:{}'", this.attributeLocalName(), context.getElement().getPrefix(), context.getElement().getLocalName());
    }

    private record Attribute(String namespaceUri, String attributeLocalName, String value) {
    }
}

