/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.message.Message;
import org.camunda.community.migration.converter.message.MessageFactory;
import org.camunda.community.migration.converter.version.SemanticVersion;
import org.camunda.community.migration.converter.visitor.AbstractFilteringVisitor;

public abstract class AbstractElementVisitor
extends AbstractFilteringVisitor {
    @Override
    protected boolean canVisit(DomElementVisitorContext context) {
        return this.namespaceUri().contains(context.getElement().getNamespaceURI()) && this.localName().equals(context.getElement().getLocalName());
    }

    protected abstract List<String> namespaceUri();

    public abstract String localName();

    @Override
    protected final void visitFilteredElement(DomElementVisitorContext context) {
        this.visitElement(context);
        SemanticVersion availableFrom = this.availableFrom(context);
        if (availableFrom == null) {
            context.addMessage(this.cannotBeConvertedMessage(context));
        } else if (this.isNotSupportedInDesiredVersion(availableFrom, SemanticVersion.parse(context.getProperties().getPlatformVersion()))) {
            context.addMessage(this.supportedInFutureVersionMessage(context, availableFrom));
        }
    }

    protected final boolean isNotSupportedInDesiredVersion(SemanticVersion availableFrom, SemanticVersion desiredVersion) {
        return availableFrom.ordinal() > desiredVersion.ordinal();
    }

    protected abstract SemanticVersion availableFrom(DomElementVisitorContext var1);

    protected abstract void visitElement(DomElementVisitorContext var1);

    protected Message supportedInFutureVersionMessage(DomElementVisitorContext context, SemanticVersion availableFrom) {
        return MessageFactory.elementAvailableInFutureVersion(this.elementNameForMessage(context.getElement()), context.getProperties().getPlatformVersion(), availableFrom.getPatchZeroVersion());
    }

    protected Message cannotBeConvertedMessage(DomElementVisitorContext context) {
        return MessageFactory.elementNotSupportedHint(this.elementNameForMessage(context.getElement()), context.getProperties().getPlatformVersion());
    }

    protected String elementNameForMessage(DomElement element) {
        return StringUtils.capitalize(element.getLocalName().replaceAll("([A-Z])", " $1"));
    }
}

