/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor.impl;

import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.convertible.AbstractActivityConvertible;
import org.camunda.community.migration.converter.expression.ExpressionTransformationResult;
import org.camunda.community.migration.converter.expression.ExpressionTransformationResultMessageFactory;
import org.camunda.community.migration.converter.expression.ExpressionTransformer;
import org.camunda.community.migration.converter.version.SemanticVersion;
import org.camunda.community.migration.converter.visitor.AbstractBpmnElementVisitor;

public class CompletionConditionVisitor
extends AbstractBpmnElementVisitor {
    @Override
    protected SemanticVersion availableFrom(DomElementVisitorContext context) {
        return SemanticVersion._8_0;
    }

    @Override
    protected void visitBpmnElement(DomElementVisitorContext context) {
        String textContent = context.getElement().getTextContent();
        ExpressionTransformationResult transformationResult = ExpressionTransformer.transform("Completion condition", textContent);
        context.addConversion(AbstractActivityConvertible.class, conversion -> conversion.getBpmnMultiInstanceLoopCharacteristics().setCompletionCondition(transformationResult.getFeelExpression()));
        context.addMessage(ExpressionTransformationResultMessageFactory.getMessage(transformationResult, "https://docs.camunda.io/docs/components/modeler/bpmn/multi-instance/#completion-condition"));
    }

    @Override
    public String localName() {
        return "completionCondition";
    }
}

