/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.ConverterProperties;
import org.camunda.community.migration.converter.DiagramCheckContext;
import org.camunda.community.migration.converter.DiagramCheckResult;
import org.camunda.community.migration.converter.NotificationService;
import org.camunda.community.migration.converter.convertible.Convertible;
import org.camunda.community.migration.converter.message.EmptyMessage;
import org.camunda.community.migration.converter.message.Message;

public interface DomElementVisitorContext {
    public DomElement getElement();

    public void addElementToRemove();

    public void addAttributeToRemove(String var1, String var2);

    public void addMessage(Message var1);

    public void setAsDiagramElement(Convertible var1);

    public <T extends Convertible> void addConversion(Class<T> var1, Consumer<T> var2);

    public void notify(Object var1);

    public ConverterProperties getProperties();

    public void references(String var1);

    public static class DefaultDomElementVisitorContext
    implements DomElementVisitorContext {
        private final DomElement element;
        private final DiagramCheckContext context;
        private final DiagramCheckResult result;
        private final NotificationService notificationService;
        private final ConverterProperties converterProperties;

        public DefaultDomElementVisitorContext(DomElement element, DiagramCheckContext context, DiagramCheckResult result, NotificationService notificationService, ConverterProperties converterProperties) {
            this.element = element;
            this.context = context;
            this.result = result;
            this.notificationService = notificationService;
            this.converterProperties = converterProperties;
        }

        @Override
        public DomElement getElement() {
            return this.element;
        }

        @Override
        public void addElementToRemove() {
            this.context.getElementsToRemove().add(this.element);
        }

        @Override
        public void addAttributeToRemove(String attributeLocalName, String namespaceUri) {
            this.context.addAttributeToRemove(this.element, namespaceUri, attributeLocalName);
        }

        @Override
        public void addMessage(Message message) {
            this.addMessage(this.element, message);
        }

        @Override
        public void setAsDiagramElement(Convertible convertible) {
            this.createElementCheckResult(this.element, convertible);
        }

        @Override
        public <T extends Convertible> void addConversion(Class<T> convertibleType, Consumer<T> operation) {
            this.addConversion(this.element, convertibleType, operation);
        }

        @Override
        public void notify(Object object) {
            this.notificationService.notify(object);
        }

        @Override
        public ConverterProperties getProperties() {
            return this.converterProperties;
        }

        @Override
        public void references(String referencedElementId) {
            this.references(this.element, referencedElementId);
        }

        private void references(DomElement element, String referencedElementId) {
            DiagramCheckResult.ElementCheckResult currentElementCheckResult = this.findBpmnElementCheckResult(element);
            DiagramCheckResult.ElementCheckResult referencedResult = this.result.getResult(referencedElementId);
            if (referencedResult != null) {
                this.createReference(currentElementCheckResult, referencedResult);
            } else {
                this.context.getReferencesToCreate().computeIfAbsent(referencedElementId, s -> new ArrayList()).add(currentElementCheckResult);
            }
        }

        private void createReference(DiagramCheckResult.ElementCheckResult references, DiagramCheckResult.ElementCheckResult referencedBy) {
            references.getReferences().add(referencedBy.getElementId());
            referencedBy.getReferencedBy().add(references.getElementId());
        }

        private void addMessage(DomElement element, Message message) {
            if (!(message instanceof EmptyMessage)) {
                this.findElementMessages(element).add(this.createMessage(message));
            }
        }

        private DiagramCheckResult.ElementCheckMessage createMessage(Message message) {
            DiagramCheckResult.ElementCheckMessage m = new DiagramCheckResult.ElementCheckMessage();
            m.setMessage(message.getMessage());
            m.setSeverity(message.getSeverity());
            m.setLink(message.getLink());
            m.setId(message.getId());
            return m;
        }

        private List<DiagramCheckResult.ElementCheckMessage> findElementMessages(DomElement element) {
            return this.findBpmnElementCheckResult(element).getMessages();
        }

        private <T extends Convertible> void addConversion(DomElement element, Class<T> type, Consumer<T> modifier) {
            T conversion = this.findConvertible(element, type);
            modifier.accept(conversion);
        }

        private <T extends Convertible> T findConvertible(DomElement element, Class<T> type) {
            if (this.context.getConvertibles().containsKey(element)) {
                return (T)((Convertible)type.cast(this.context.getConvertibles().get(element)));
            }
            return this.findConvertible(element.getParentElement(), type);
        }

        private DiagramCheckResult.ElementCheckResult findBpmnElementCheckResult(DomElement element) {
            return this.result.getResults().stream().filter(r -> r.getElementId().equals(this.extractId(element))).findFirst().orElseGet(() -> this.findBpmnElementCheckResult(element.getParentElement()));
        }

        private String extractId(DomElement element) {
            return element.getAttribute("id");
        }

        private void createElementCheckResult(DomElement element, Convertible convertible) {
            String id = this.extractId(element);
            Objects.requireNonNull(id);
            if (this.containsId(id)) {
                throw new IllegalStateException("Element with id '" + id + "' is already contained in list of results");
            }
            DiagramCheckResult.ElementCheckResult result = new DiagramCheckResult.ElementCheckResult();
            this.context.addConvertible(element, convertible);
            result.setElementId(id);
            result.setElementName(element.getAttribute("name"));
            result.setElementType(element.getLocalName());
            List elementCheckResults = this.context.getReferencesToCreate().getOrDefault(id, new ArrayList());
            elementCheckResults.forEach(other -> this.createReference((DiagramCheckResult.ElementCheckResult)other, result));
            this.result.getResults().add(result);
        }

        private boolean containsId(String id) {
            return this.result.getResults().stream().anyMatch(r -> r.getElementId().equals(id));
        }
    }
}

