/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.cli;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.camunda.bpm.model.xml.ModelInstance;
import org.camunda.community.migration.converter.DiagramType;
import org.camunda.community.migration.converter.cli.AbstractConvertCommand;
import org.camunda.community.migration.converter.cli.DecisionDefinitionDto;
import org.camunda.community.migration.converter.cli.ProcessDefinitionDto;
import org.camunda.community.migration.converter.cli.ProcessEngineClient;
import picocli.CommandLine;

@CommandLine.Command(name="engine", descriptionHeading="Description: ", description={"Converts the diagrams from the given process engine", "%nExecute as:", "%njava -Dfile.encoding=UTF-8 -jar backend-diagram-converter-cli.jar engine%n"}, mixinStandardHelpOptions=true, optionListHeading="Options:%n", parameterListHeading="Parameter:%n", showDefaultValues=true)
public class ConvertEngineCommand
extends AbstractConvertCommand {
    private static final String DEFAULT_URL = "http://localhost:8080/engine-rest";
    @CommandLine.Parameters(index="0", description={"Fully qualified http(s) address to the process engine REST API"}, defaultValue="http://localhost:8080/engine-rest")
    String url = "http://localhost:8080/engine-rest";
    @CommandLine.Option(names={"-u", "--username"}, description={"Username for basic auth"})
    String username;
    @CommandLine.Option(names={"-p", "--password"}, description={"Password for basic auth"})
    String password;
    @CommandLine.Option(names={"-t", "--target-directory"}, description={"The directory to save the .bpmn files"}, defaultValue=".")
    File targetDirectory = new File(".");

    @Override
    protected File targetDirectory() {
        return this.targetDirectory;
    }

    @Override
    protected Map<File, ModelInstance> modelInstances() {
        Map<String, Map<String, Set<String>>> allLatestBpmnXml = this.getAllLatestBpmnXml();
        allLatestBpmnXml.putAll(this.getAllLatestDmnXml());
        HashMap<File, ModelInstance> result = new HashMap<File, ModelInstance>();
        allLatestBpmnXml.forEach((resourceName, models) -> models.forEach((model, processDefinitionKeys) -> {
            String filename = models.size() == 1 ? resourceName : FilenameUtils.getBaseName(resourceName) + " (" + String.join((CharSequence)", ", processDefinitionKeys) + ")." + FilenameUtils.getExtension(resourceName);
            result.put(new File(this.targetDirectory, filename), DiagramType.fromFileName(filename).readDiagram(new ByteArrayInputStream(model.getBytes())));
        }));
        return result;
    }

    private Map<String, Map<String, Set<String>>> getAllLatestBpmnXml() {
        ProcessEngineClient client = ProcessEngineClient.withEngine(this.url, this.username, this.password);
        return client.getAllLatestProcessDefinitions().stream().collect(Collectors.groupingBy(ProcessDefinitionDto::getResource, Collectors.groupingBy(pd -> client.getBpmnXml(pd.getId()).getBpmn20Xml(), Collectors.mapping(ProcessDefinitionDto::getKey, Collectors.toSet()))));
    }

    private Map<String, Map<String, Set<String>>> getAllLatestDmnXml() {
        ProcessEngineClient client = ProcessEngineClient.withEngine(this.url, this.username, this.password);
        return client.getAllLatestDecisionDefinitions().stream().collect(Collectors.groupingBy(DecisionDefinitionDto::getResource, Collectors.groupingBy(pd -> client.getDmnXml(pd.getId()).getDmnXml(), Collectors.mapping(DecisionDefinitionDto::getKey, Collectors.toSet()))));
    }
}

