/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.conversion;

import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.BpmnElementFactory;
import org.camunda.community.migration.converter.conversion.AbstractTypedConversion;
import org.camunda.community.migration.converter.convertible.AbstractExecutionListenerConvertible;

public class ExecutionListenerConversion
extends AbstractTypedConversion<AbstractExecutionListenerConvertible> {
    @Override
    protected Class<AbstractExecutionListenerConvertible> type() {
        return AbstractExecutionListenerConvertible.class;
    }

    @Override
    protected void convertTyped(DomElement element, AbstractExecutionListenerConvertible convertible) {
        if (convertible.getZeebeExecutionListeners() != null && !convertible.getZeebeExecutionListeners().isEmpty()) {
            DomElement extensionElements = BpmnElementFactory.getExtensionElements(element);
            DomElement executionListeners = this.createExecutionListeners(extensionElements);
            for (AbstractExecutionListenerConvertible.ZeebeExecutionListener executionListener : convertible.getZeebeExecutionListeners()) {
                this.createExecutionListener(executionListeners, executionListener);
            }
        }
    }

    private void createExecutionListener(DomElement executionListeners, AbstractExecutionListenerConvertible.ZeebeExecutionListener executionListener) {
        DomElement executionListenerDom = executionListeners.getDocument().createElement("http://camunda.org/schema/zeebe/1.0", "executionListener");
        executionListenerDom.setAttribute("http://camunda.org/schema/zeebe/1.0", "eventType", executionListener.getEventType().name());
        executionListenerDom.setAttribute("http://camunda.org/schema/zeebe/1.0", "type", executionListener.getListenerType());
        if (StringUtils.isNotBlank(executionListener.getRetries())) {
            executionListenerDom.setAttribute("http://camunda.org/schema/zeebe/1.0", "retries", executionListener.getRetries());
        }
        executionListeners.appendChild(executionListenerDom);
    }

    private DomElement createExecutionListeners(DomElement extensionElements) {
        DomElement executionListeners = extensionElements.getDocument().createElement("http://camunda.org/schema/zeebe/1.0", "executionListeners");
        extensionElements.appendChild(executionListeners);
        return executionListeners;
    }
}

