/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor.impl;

import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.version.SemanticVersion;
import org.camunda.community.migration.converter.visitor.AbstractDmnElementVisitor;

public class DmnDefinitionsVisitor
extends AbstractDmnElementVisitor {
    private static final String VERSION_HEADER = "executionPlatformVersion";
    private static final String PLATFORM_HEADER = "executionPlatform";
    private static final String CONVERTER_VERSION_HEADER = "converterVersion";
    private static final String PLATFORM_VALUE = "Camunda Cloud";
    private static final String ZEEBE_NAMESPACE_NAME = "zeebe";
    private static final String CONVERSION_NAMESPACE_NAME = "conversion";
    private static final String MODELER_NAMESPACE_NAME = "modeler";

    @Override
    protected void visitDmnElement(DomElementVisitorContext context) {
        SemanticVersion desiredVersion = SemanticVersion.parse(context.getProperties().getPlatformVersion());
        DomElement element = context.getElement();
        String executionPlatform = element.getAttribute("http://camunda.org/schema/modeler/1.0", VERSION_HEADER);
        if (executionPlatform != null && executionPlatform.startsWith("8")) {
            throw new RuntimeException("This diagram is already a Camunda 8 diagram");
        }
        element.registerNamespace(MODELER_NAMESPACE_NAME, "http://camunda.org/schema/modeler/1.0");
        element.registerNamespace(ZEEBE_NAMESPACE_NAME, "http://camunda.org/schema/zeebe/1.0");
        element.registerNamespace(CONVERSION_NAMESPACE_NAME, "http://camunda.org/schema/conversion/1.0");
        element.setAttribute("http://camunda.org/schema/modeler/1.0", PLATFORM_HEADER, PLATFORM_VALUE);
        element.setAttribute("http://camunda.org/schema/modeler/1.0", VERSION_HEADER, desiredVersion.getPatchZeroVersion());
        element.setAttribute("http://camunda.org/schema/conversion/1.0", CONVERTER_VERSION_HEADER, this.getClass().getPackage().getImplementationVersion());
    }

    @Override
    public String localName() {
        return "definitions";
    }
}

