/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor.impl.eventReference;

import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.convertible.Convertible;
import org.camunda.community.migration.converter.convertible.EscalationConvertible;
import org.camunda.community.migration.converter.expression.ExpressionTransformationResult;
import org.camunda.community.migration.converter.expression.ExpressionTransformer;
import org.camunda.community.migration.converter.message.MessageFactory;
import org.camunda.community.migration.converter.version.SemanticVersion;
import org.camunda.community.migration.converter.visitor.AbstractEventReferenceVisitor;

public class EscalationVisitor
extends AbstractEventReferenceVisitor {
    @Override
    public String localName() {
        return "escalation";
    }

    @Override
    protected Convertible createConvertible(DomElementVisitorContext context) {
        return new EscalationConvertible();
    }

    @Override
    protected SemanticVersion availableFrom(DomElementVisitorContext context) {
        return SemanticVersion._8_2;
    }

    @Override
    protected void postCreationVisitor(DomElementVisitorContext context) {
        String escalationCode = context.getElement().getAttribute("http://www.omg.org/spec/BPMN/20100524/MODEL", "escalationCode");
        if (escalationCode != null) {
            ExpressionTransformationResult expressionTransformationResult = ExpressionTransformer.transform("Escalation", escalationCode);
            context.addConversion(EscalationConvertible.class, c -> c.setEscalationCode(expressionTransformationResult.getFeelExpression()));
            if (expressionTransformationResult != null && expressionTransformationResult.getFeelExpression().startsWith("=")) {
                context.addMessage(MessageFactory.escalationCodeNoExpression());
            }
        }
    }
}

