/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.support;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.MultiValueMap;

public final class JettyHeadersAdapter
implements MultiValueMap<String, String> {
    private final HttpFields headers;
    @Nullable
    private final HttpFields.Mutable mutable;

    public JettyHeadersAdapter(HttpFields headers) {
        HttpFields.Mutable m;
        Assert.notNull((Object)headers, "Headers must not be null");
        this.headers = headers;
        this.mutable = headers instanceof HttpFields.Mutable ? (m = (HttpFields.Mutable)headers) : null;
    }

    @Override
    public String getFirst(String key) {
        return this.headers.get(key);
    }

    @Override
    public void add(String key, @Nullable String value) {
        if (value != null) {
            HttpFields.Mutable mutableHttpFields = this.mutableFields();
            mutableHttpFields.add(key, value);
        }
    }

    @Override
    public void addAll(String key, List<? extends String> values) {
        values.forEach((? super T value) -> this.add(key, (String)value));
    }

    @Override
    public void addAll(MultiValueMap<String, String> values) {
        values.forEach(this::addAll);
    }

    @Override
    public void set(String key, @Nullable String value) {
        HttpFields.Mutable mutableHttpFields = this.mutableFields();
        if (value != null) {
            mutableHttpFields.put(key, value);
        } else {
            mutableHttpFields.remove(key);
        }
    }

    @Override
    public void setAll(Map<String, String> values) {
        values.forEach(this::set);
    }

    @Override
    public Map<String, String> toSingleValueMap() {
        LinkedCaseInsensitiveMap<String> singleValueMap = new LinkedCaseInsensitiveMap<String>(this.headers.size(), Locale.ROOT);
        Iterator iterator = this.headers.iterator();
        iterator.forEachRemaining(field -> {
            if (!singleValueMap.containsKey(field.getName())) {
                singleValueMap.put(field.getName(), field.getValue());
            }
        });
        return singleValueMap;
    }

    @Override
    public int size() {
        return this.headers.getFieldNamesCollection().size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        String name;
        return key instanceof String && this.headers.contains(name = (String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof String) {
            String searchString = (String)value;
            for (HttpField field : this.headers) {
                if (!field.contains(searchString)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public List<String> get(Object key) {
        ArrayList<String> list = null;
        if (key instanceof String) {
            String name = (String)key;
            for (HttpField f : this.headers) {
                if (!f.is(name)) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(f.getValue());
            }
        }
        return list;
    }

    @Override
    @Nullable
    public List<String> put(String key, List<String> value) {
        HttpFields.Mutable mutableHttpFields = this.mutableFields();
        Object oldValues = this.get(key);
        if (oldValues == null) {
            switch (value.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    mutableHttpFields.add(key, value.get(0));
                    break;
                }
                default: {
                    mutableHttpFields.add(key, value);
                    break;
                }
            }
        } else {
            switch (value.size()) {
                case 0: {
                    mutableHttpFields.remove(key);
                    break;
                }
                case 1: {
                    mutableHttpFields.put(key, value.get(0));
                    break;
                }
                default: {
                    mutableHttpFields.put(key, value);
                }
            }
        }
        return oldValues;
    }

    @Override
    @Nullable
    public List<String> remove(Object key) {
        HttpFields.Mutable mutableHttpFields = this.mutableFields();
        ArrayList<String> list = null;
        if (key instanceof String) {
            String name = (String)key;
            ListIterator i = mutableHttpFields.listIterator();
            while (i.hasNext()) {
                HttpField f = (HttpField)i.next();
                if (!f.is(name)) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(f.getValue());
                i.remove();
            }
        }
        return list;
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> map) {
        map.forEach(this::put);
    }

    @Override
    public void clear() {
        HttpFields.Mutable mutableHttpFields = this.mutableFields();
        mutableHttpFields.clear();
    }

    @Override
    public Set<String> keySet() {
        return new HeaderNames();
    }

    @Override
    public Collection<List<String>> values() {
        return this.headers.getFieldNamesCollection().stream().map(arg_0 -> ((HttpFields)this.headers).getValuesList(arg_0)).toList();
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return new AbstractSet<Map.Entry<String, List<String>>>(){

            @Override
            public Iterator<Map.Entry<String, List<String>>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return JettyHeadersAdapter.this.headers.getFieldNamesCollection().size();
            }
        };
    }

    private HttpFields.Mutable mutableFields() {
        if (this.mutable == null) {
            throw new IllegalStateException("Immutable headers");
        }
        return this.mutable;
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this);
    }

    private class HeaderNames
    extends AbstractSet<String> {
        private HeaderNames() {
        }

        @Override
        public Iterator<String> iterator() {
            return new HeaderNamesIterator(JettyHeadersAdapter.this.headers.getFieldNamesCollection().iterator());
        }

        @Override
        public int size() {
            return JettyHeadersAdapter.this.headers.getFieldNamesCollection().size();
        }
    }

    private final class HeaderNamesIterator
    implements Iterator<String> {
        private final Iterator<String> iterator;
        @Nullable
        private String currentName;

        private HeaderNamesIterator(Iterator<String> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            this.currentName = this.iterator.next();
            return this.currentName;
        }

        @Override
        public void remove() {
            HttpFields.Mutable mutableHttpFields = JettyHeadersAdapter.this.mutableFields();
            if (this.currentName == null) {
                throw new IllegalStateException("No current Header in iterator");
            }
            if (!JettyHeadersAdapter.this.headers.contains(this.currentName)) {
                throw new IllegalStateException("Header not present: " + this.currentName);
            }
            mutableHttpFields.remove(this.currentName);
        }
    }

    private class HeaderEntry
    implements Map.Entry<String, List<String>> {
        private final String key;

        HeaderEntry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public List<String> getValue() {
            return JettyHeadersAdapter.this.headers.getValuesList(this.key);
        }

        @Override
        public List<String> setValue(List<String> value) {
            HttpFields.Mutable mutableHttpFields = JettyHeadersAdapter.this.mutableFields();
            List previousValues = JettyHeadersAdapter.this.headers.getValuesList(this.key);
            mutableHttpFields.put(this.key, value);
            return previousValues;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<String, List<String>>> {
        private final Iterator<String> names;

        private EntryIterator() {
            this.names = JettyHeadersAdapter.this.headers.getFieldNamesCollection().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.names.hasNext();
        }

        @Override
        public Map.Entry<String, List<String>> next() {
            return new HeaderEntry(this.names.next());
        }
    }
}

