/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.NestedExceptionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DisconnectedClientHelper {
    private static final Set<String> EXCEPTION_PHRASES = Set.of("broken pipe", "connection reset by peer");
    private static final Set<String> EXCEPTION_TYPE_NAMES = Set.of("AbortedException", "ClientAbortException", "EOFException", "EofException", "AsyncRequestNotUsableException");
    private static final Set<Class<?>> CLIENT_EXCEPTION_TYPES = new HashSet(2);
    private final Log logger;

    public DisconnectedClientHelper(String logCategory) {
        Assert.notNull((Object)logCategory, "'logCategory' is required");
        this.logger = LogFactory.getLog(logCategory);
    }

    public boolean checkAndLogClientDisconnectedException(Throwable ex) {
        if (DisconnectedClientHelper.isClientDisconnectedException(ex)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Looks like the client has gone away", ex);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Looks like the client has gone away: " + String.valueOf(ex) + " (For a full stack trace, set the log category '" + String.valueOf(this.logger) + "' to TRACE level.)");
            }
            return true;
        }
        return false;
    }

    public static boolean isClientDisconnectedException(Throwable ex) {
        Throwable lastEx = null;
        for (Throwable currentEx = ex; currentEx != null && currentEx != lastEx; currentEx = currentEx.getCause()) {
            for (Class<?> exceptionType : CLIENT_EXCEPTION_TYPES) {
                if (!exceptionType.isInstance(currentEx)) continue;
                return false;
            }
            if (EXCEPTION_TYPE_NAMES.contains(currentEx.getClass().getSimpleName())) {
                return true;
            }
            lastEx = currentEx;
        }
        String message = NestedExceptionUtils.getMostSpecificCause(ex).getMessage();
        if (message != null) {
            String text = message.toLowerCase(Locale.ROOT);
            for (String phrase : EXCEPTION_PHRASES) {
                if (!text.contains(phrase)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        try {
            ClassLoader classLoader = DisconnectedClientHelper.class.getClassLoader();
            CLIENT_EXCEPTION_TYPES.add(ClassUtils.forName("org.springframework.web.client.RestClientException", classLoader));
            CLIENT_EXCEPTION_TYPES.add(ClassUtils.forName("org.springframework.web.reactive.function.client.WebClientException", classLoader));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

