/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.converter;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.xml.impl.util.ModelIoException;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.converter.BpmnDiagramCheckContext;
import org.camunda.community.converter.BpmnDiagramCheckResult;
import org.camunda.community.converter.ConverterProperties;
import org.camunda.community.converter.DomElementVisitorContext;
import org.camunda.community.converter.MessageAppender;
import org.camunda.community.converter.NotificationService;
import org.camunda.community.converter.conversion.Conversion;
import org.camunda.community.converter.convertible.Convertible;
import org.camunda.community.converter.visitor.AbstractProcessElementVisitor;
import org.camunda.community.converter.visitor.DomElementVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnConverter {
    private static final Logger LOG = LoggerFactory.getLogger(BpmnConverter.class);
    private final List<DomElementVisitor> visitors;
    private final List<Conversion> conversions;
    private final NotificationService notificationService;

    public BpmnConverter(List<DomElementVisitor> visitors, List<Conversion> conversions, NotificationService notificationService) {
        this.visitors = visitors;
        this.conversions = conversions;
        this.notificationService = notificationService;
    }

    public void convert(BpmnModelInstance modelInstance, boolean appendDocumentation, ConverterProperties properties) {
        this.check(null, modelInstance, appendDocumentation, properties);
    }

    public BpmnDiagramCheckResult check(String filename, BpmnModelInstance modelInstance, boolean appendDocumentation, ConverterProperties properties) {
        LOG.info("Start check");
        BpmnDiagramCheckResult result = new BpmnDiagramCheckResult();
        result.setFilename(filename);
        BpmnDiagramCheckContext context = new BpmnDiagramCheckContext();
        this.traverse(modelInstance.getDocument().getRootElement(), result, context, properties);
        LOG.info("Done check");
        LOG.info("Start remove of old elements");
        context.getElementsToRemove().forEach(element -> element.getParentElement().removeChild((DomElement)element));
        context.getAttributesToRemove().forEach((element, stringSetMap) -> stringSetMap.forEach((namespaceUri, attributes) -> attributes.forEach(attribute -> element.removeAttribute((String)namespaceUri, (String)attribute))));
        LOG.info("Done remove of old elements");
        LOG.info("Start conversion");
        MessageAppender messageAppender = new MessageAppender();
        context.getConvertibles().forEach((element, convertible) -> {
            List<BpmnDiagramCheckResult.BpmnElementCheckMessage> messages = this.getMessages((DomElement)element, result);
            messageAppender.appendMessages((DomElement)element, messages, appendDocumentation);
            this.conversions.forEach(conversion -> conversion.convert((DomElement)element, (Convertible)convertible, messages));
        });
        LOG.info("Done with conversion");
        return result;
    }

    private List<BpmnDiagramCheckResult.BpmnElementCheckMessage> getMessages(DomElement element, BpmnDiagramCheckResult result) {
        return result.getResults().stream().filter(r -> r.getElementId().equals(element.getAttribute("id"))).map(BpmnDiagramCheckResult.BpmnElementCheckResult::getMessages).findFirst().orElseGet(ArrayList::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printXml(DomDocument document, boolean prettyPrint, Writer writer) {
        StreamResult result = new StreamResult(writer);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("prettyprint.xsl");){
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(new InputStreamReader(in)));
            transformer.setOutputProperty("encoding", "UTF-8");
            if (prettyPrint) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            }
            DomDocument domDocument = document;
            synchronized (domDocument) {
                transformer.transform(document.getDomSource(), result);
            }
        }
        catch (TransformerConfigurationException e) {
            throw new ModelIoException("Unable to create a transformer for the model", e);
        }
        catch (TransformerException e) {
            throw new ModelIoException("Unable to transform model to xml", e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void traverse(DomElement element, BpmnDiagramCheckResult result, BpmnDiagramCheckContext context, ConverterProperties properties) {
        DomElementVisitorContext.DefaultDomElementVisitorContext elementContext = new DomElementVisitorContext.DefaultDomElementVisitorContext(element, context, result, this.notificationService, properties);
        this.visitors.stream().sorted(Comparator.comparingInt(v -> v instanceof AbstractProcessElementVisitor ? 2 : 3)).forEach(visitor -> visitor.visit(elementContext));
        element.getChildElements().forEach(child -> this.traverse((DomElement)child, result, context, properties));
    }
}

