/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.converter.conversion;

import java.util.List;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.converter.BpmnDiagramCheckResult;
import org.camunda.community.converter.BpmnElementFactory;
import org.camunda.community.converter.conversion.Conversion;
import org.camunda.community.converter.convertible.Convertible;

public abstract class AbstractTypedConversion<T extends Convertible>
implements Conversion {
    @Override
    public final void convert(DomElement element, Convertible convertible, List<BpmnDiagramCheckResult.BpmnElementCheckMessage> messages) {
        if (this.type().isAssignableFrom(convertible.getClass())) {
            this.convertTyped(element, (Convertible)this.type().cast(convertible));
        }
        this.removeIfEmpty(BpmnElementFactory.getExtensionElements(element));
        this.removeIfEmpty(BpmnElementFactory.getDocumentation(element));
    }

    private void removeIfEmpty(DomElement extensionElements) {
        if (extensionElements.getChildElements().isEmpty() && (extensionElements.getTextContent() == null || extensionElements.getTextContent().trim().equals(""))) {
            extensionElements.getParentElement().removeChild(extensionElements);
        }
    }

    protected abstract Class<T> type();

    protected abstract void convertTyped(DomElement var1, T var2);
}

