/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.util;

import io.camunda.zeebe.model.bpmn.instance.Activity;
import io.camunda.zeebe.model.bpmn.instance.BoundaryEvent;
import io.camunda.zeebe.model.bpmn.instance.Error;
import io.camunda.zeebe.model.bpmn.instance.ErrorEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Message;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.model.bpmn.instance.TimerEventDefinition;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public class ModelUtil {
    private static final List<Class<? extends EventDefinition>> NON_INTERRUPTING_EVENT_DEFINITIONS = Arrays.asList(MessageEventDefinition.class, TimerEventDefinition.class);

    public static List<EventDefinition> getEventDefinitionsForBoundaryEvents(Activity element) {
        return element.getBoundaryEvents().stream().flatMap(event -> event.getEventDefinitions().stream()).collect(Collectors.toList());
    }

    public static List<EventDefinition> getEventDefinitionsForEventSubprocesses(ModelElementInstance element) {
        return element.getChildElementsByType(SubProcess.class).stream().filter(SubProcess::triggeredByEvent).flatMap(subProcess -> subProcess.getChildElementsByType(StartEvent.class).stream()).flatMap(s -> s.getEventDefinitions().stream()).collect(Collectors.toList());
    }

    public static List<String> getDuplicateMessageNames(Stream<MessageEventDefinition> eventDefinitions) {
        Stream<Message> messages = eventDefinitions.map(MessageEventDefinition::getMessage).filter(m -> m.getName() != null && !m.getName().isEmpty());
        return messages.collect(Collectors.groupingBy(Message::getName, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static void verifyNoDuplicatedBoundaryEvents(Activity activity, Consumer<String> errorCollector) {
        List<EventDefinition> definitions = ModelUtil.getEventDefinitionsForBoundaryEvents(activity);
        ModelUtil.verifyNoDuplicatedEventDefinition(definitions, errorCollector);
    }

    public static void verifyEventDefinition(BoundaryEvent boundaryEvent, Consumer<String> errorCollector) {
        boundaryEvent.getEventDefinitions().forEach(definition -> ModelUtil.verifyEventDefinition(definition, boundaryEvent.cancelActivity(), errorCollector));
    }

    public static void verifyEventDefinition(StartEvent startEvent, Consumer<String> errorCollector) {
        startEvent.getEventDefinitions().forEach(definition -> ModelUtil.verifyEventDefinition(definition, startEvent.isInterrupting(), errorCollector));
    }

    public static void verifyNoDuplicatedEventSubprocesses(ModelElementInstance element, Consumer<String> errorCollector) {
        List<EventDefinition> definitions = ModelUtil.getEventDefinitionsForEventSubprocesses(element);
        ModelUtil.verifyNoDuplicatedEventDefinition(definitions, errorCollector);
    }

    public static void verifyNoDuplicatedEventDefinition(Collection<? extends EventDefinition> definitions, Consumer<String> errorCollector) {
        Stream<String> messageNames = ModelUtil.getEventDefinition(definitions, MessageEventDefinition.class).filter(def -> def.getMessage() != null).map(MessageEventDefinition::getMessage).filter(message -> message.getName() != null && !message.getName().isEmpty()).map(Message::getName);
        ModelUtil.getDuplicatedEntries(messageNames).map(ModelUtil::duplicatedMessageNames).forEach(errorCollector);
        Stream<String> errorCodes = ModelUtil.getEventDefinition(definitions, ErrorEventDefinition.class).filter(def -> def.getError() != null).map(ErrorEventDefinition::getError).filter(error -> error.getErrorCode() != null && !error.getErrorCode().isEmpty()).map(Error::getErrorCode);
        ModelUtil.getDuplicatedEntries(errorCodes).map(ModelUtil::duplicatedErrorCodes).forEach(errorCollector);
    }

    public static <T extends EventDefinition> Stream<T> getEventDefinition(Collection<? extends EventDefinition> collection, Class<T> type) {
        return collection.stream().filter(type::isInstance).map(type::cast);
    }

    public static Stream<String> getDuplicatedEntries(Stream<String> stream) {
        return stream.collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey);
    }

    private static String duplicatedMessageNames(String messageName) {
        return String.format("Multiple message event definitions with the same name '%s' are not allowed.", messageName);
    }

    private static String duplicatedErrorCodes(String errorCode) {
        return String.format("Multiple error event definitions with the same errorCode '%s' are not allowed.", errorCode);
    }

    private static void verifyEventDefinition(EventDefinition definition, boolean isInterrupting, Consumer<String> errorCollector) {
        TimerEventDefinition timerEventDefinition;
        if (!isInterrupting && !NON_INTERRUPTING_EVENT_DEFINITIONS.contains(definition.getElementType().getInstanceType())) {
            errorCollector.accept("Non-Interrupting event of this type is not allowed");
        }
        if (isInterrupting && definition instanceof TimerEventDefinition && (timerEventDefinition = (TimerEventDefinition)definition).getTimeCycle() != null) {
            errorCollector.accept("Interrupting timer event with time cycle is not allowed.");
        }
    }
}

