/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.converter;

import java.util.Comparator;
import java.util.List;
import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.converter.BpmnDiagramCheckResult;
import org.camunda.community.converter.BpmnElementFactory;

public class MessageAppender {
    public void appendMessages(DomElement element, List<BpmnDiagramCheckResult.BpmnElementCheckMessage> messages, boolean appendDocumentation) {
        if (!messages.isEmpty()) {
            DomElement extensionElements = BpmnElementFactory.getExtensionElements(element);
            messages.sort(Comparator.comparingInt(message -> message.getSeverity().ordinal()));
            messages.forEach(message -> extensionElements.appendChild(this.createMessage((BpmnDiagramCheckResult.BpmnElementCheckMessage)message, element.getDocument())));
            if (appendDocumentation) {
                DomElement documentation = BpmnElementFactory.getDocumentation(element);
                documentation.setTextContent(this.createDocumentation(documentation.getTextContent(), messages));
            }
        }
    }

    private String createDocumentation(String currentDocumentation, List<BpmnDiagramCheckResult.BpmnElementCheckMessage> messages) {
        StringBuilder documentation = new StringBuilder(currentDocumentation == null ? "" : currentDocumentation);
        if (currentDocumentation != null && currentDocumentation.trim().length() > 0) {
            documentation.append("\n\n");
        }
        messages.forEach(message -> documentation.append(this.formatMessage((BpmnDiagramCheckResult.BpmnElementCheckMessage)message)));
        return documentation.toString();
    }

    private String formatMessage(BpmnDiagramCheckResult.BpmnElementCheckMessage message) {
        return "- " + (Object)((Object)message.getSeverity()) + ": " + message.getMessage() + "\n";
    }

    private DomElement createMessage(BpmnDiagramCheckResult.BpmnElementCheckMessage message, DomDocument document) {
        DomElement messageElement = document.createElement("http://camunda.org/schema/conversion/1.0", "message");
        messageElement.setAttribute("severity", message.getSeverity().name());
        if (message.getLink() != null) {
            messageElement.setAttribute("link", message.getLink());
        }
        messageElement.setTextContent(message.getMessage());
        return messageElement;
    }
}

