/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.converter.conversion;

import org.camunda.bpm.model.xml.instance.DomDocument;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.converter.BpmnElementFactory;
import org.camunda.community.converter.conversion.AbstractTypedConversion;
import org.camunda.community.converter.convertible.UserTaskConvertible;

public class UserTaskConversion
extends AbstractTypedConversion<UserTaskConvertible> {
    @Override
    protected void convertTyped(DomElement element, UserTaskConvertible convertible) {
        DomElement extensionElements = BpmnElementFactory.getExtensionElements(element);
        if (this.canAddFormDefinition(convertible)) {
            extensionElements.appendChild(this.createFormDefinition(element.getDocument(), convertible));
        }
        if (this.canAddAssignmentDefinition(convertible)) {
            extensionElements.appendChild(this.createAssignmentDefinition(element.getDocument(), convertible));
        }
    }

    private DomElement createFormDefinition(DomDocument document, UserTaskConvertible convertible) {
        DomElement formDefinition = document.createElement("http://camunda.org/schema/zeebe/1.0", "formDefinition");
        formDefinition.setAttribute("formKey", convertible.getZeebeFormDefinition().getFormKey());
        return formDefinition;
    }

    private DomElement createAssignmentDefinition(DomDocument document, UserTaskConvertible convertible) {
        DomElement assignmentDefinition = document.createElement("http://camunda.org/schema/zeebe/1.0", "assignmentDefinition");
        assignmentDefinition.setAttribute("assignee", convertible.getZeebeAssignmentDefinition().getAssignee());
        assignmentDefinition.setAttribute("candidateGroups", convertible.getZeebeAssignmentDefinition().getCandidateGroups());
        return assignmentDefinition;
    }

    private boolean canAddFormDefinition(UserTaskConvertible convertible) {
        return convertible.getZeebeFormDefinition().getFormKey() != null;
    }

    private boolean canAddAssignmentDefinition(UserTaskConvertible convertible) {
        return convertible.getZeebeAssignmentDefinition().getAssignee() != null || convertible.getZeebeAssignmentDefinition().getCandidateGroups() != null;
    }

    @Override
    protected Class<UserTaskConvertible> type() {
        return UserTaskConvertible.class;
    }
}

