/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.converter.exception;

import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.converter.visitor.DomElementVisitor;

public class VisitorException
extends RuntimeException {
    private final Class<? extends DomElementVisitor> exceptionCausingVisitor;
    private final DomElement element;

    public VisitorException(Class<? extends DomElementVisitor> exceptionCausingVisitor, DomElement element, Throwable cause) {
        super(cause);
        this.exceptionCausingVisitor = exceptionCausingVisitor;
        this.element = element;
    }

    @Override
    public String getMessage() {
        return "Exception in visitor " + this.exceptionCausingVisitor.getName() + " while visiting element " + this.buildPath(this.element) + " caused by: " + this.getCause().getMessage();
    }

    private String buildPath(DomElement element) {
        if (element == null) {
            return "";
        }
        String thisElement = element.getPrefix() + ":" + element.getLocalName();
        if (element.getAttribute("id") != null) {
            thisElement = thisElement + " (" + element.getAttribute("id") + ")";
        }
        return this.buildPath(element.getParentElement()) + " -> " + thisElement;
    }
}

