/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.converter.expression;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.camunda.community.converter.expression.ExpressionTransformationResult;

public class ExpressionTransformer {
    private static final ExpressionTransformer INSTANCE = new ExpressionTransformer();

    private ExpressionTransformer() {
    }

    public static ExpressionTransformationResult transform(String expression) {
        if (expression == null) {
            return null;
        }
        String transform = INSTANCE.doTransform(expression);
        ExpressionTransformationResult result = new ExpressionTransformationResult();
        result.setOldExpression(expression);
        result.setNewExpression(transform);
        return result;
    }

    private String doTransform(String expression) {
        if (expression == null) {
            return null;
        }
        List nonExpressions = Arrays.stream(expression.split("(#|\\$)\\{.*}")).map(String::trim).filter(s -> s.length() > 0).collect(Collectors.toList());
        if (nonExpressions.size() == 1 && expression.trim().length() == ((String)nonExpressions.get(0)).length()) {
            return expression;
        }
        List expressions = Arrays.stream(expression.split("(#|\\$)\\{|}")).map(String::trim).filter(s -> s.length() > 0).map(s -> nonExpressions.contains(s) ? "\"" + s + "\"" : this.handleExpression((String)s)).collect(Collectors.toList());
        return "=" + String.join((CharSequence)" + ", expressions);
    }

    private String handleExpression(String expression) {
        String replaced = expression.replaceAll("!(?![\\(=])([\\w-^]*)", "not($1)").replaceAll("not (?![\\(=])([\\w-^]*)", "not($1)").replaceAll("\\[\\\"(\\D[^\\]\\[]*)\\\"]", ".$1").replaceAll(" gt ", " > ").replaceAll(" lt ", " < ").replaceAll("==", "=").replaceAll(" eq ", " = ").replaceAll(" ne ", " != ").replaceAll("!\\(([^\\(\\)]*)\\)", "not($1)").replaceAll(" && ", " and ").replaceAll(" \\|\\| ", " or ");
        Pattern pattern = Pattern.compile("\\[(\\d*)\\]");
        Matcher m = pattern.matcher(replaced);
        while (m.find()) {
            String oldIndex = "[" + Long.parseLong(m.group(1)) + "]";
            String newIndex = "[" + (Long.parseLong(m.group(1)) + 1L) + "]";
            replaced = replaced.replace(oldIndex, newIndex);
        }
        return replaced;
    }
}

