/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.converter.message;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.community.converter.message.MessageTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTemplateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(MessageTemplateProcessor.class);
    private static final String PREFIX = "\\{\\{ *";
    private static final String SUFFIX = " *}}";
    private static final Pattern PLACEHOLDER = Pattern.compile("\\{\\{([^\\{\\{\\}\\}]*)}}");
    private static final String TEMPLATES_PREFIX = "templates.";

    public String decorate(MessageTemplate template, Map<String, String> context) {
        String templateString = template.getTemplate();
        ArrayList<String> missingVariables = new ArrayList<String>();
        LOG.debug("Filling template '{}' with context {}", (Object)templateString, (Object)context);
        for (String variableName : template.getVariables()) {
            String value = context.get(variableName);
            if (value == null) {
                missingVariables.add(variableName);
                continue;
            }
            value = value.replaceAll("\\$", "\\\\\\$");
            LOG.debug("Replacing {} with {}", (Object)variableName, (Object)value);
            templateString = templateString.replaceAll(PREFIX + variableName + SUFFIX, value);
            LOG.debug("Template after replacement: {}", (Object)templateString);
        }
        if (!missingVariables.isEmpty()) {
            throw new IllegalStateException("Error while decorating template '" + template.getTemplate() + "': Variables '" + missingVariables + "' are missing");
        }
        return templateString;
    }

    public List<String> extractVariables(String template) {
        LOG.debug("Extracting variables from '{}'", (Object)template);
        Matcher matcher = PLACEHOLDER.matcher(template);
        ArrayList<String> variables = new ArrayList<String>();
        while (matcher.find()) {
            String group = matcher.group(1).trim();
            if (group.startsWith(TEMPLATES_PREFIX) || variables.contains(group)) continue;
            LOG.debug("Found {}", (Object)group);
            variables.add(group);
        }
        return variables;
    }

    public void replaceTemplates(Map<String, String> templates) {
        LOG.debug("Replacing templates");
        boolean templateFound = true;
        while (templateFound) {
            templateFound = false;
            HashMap<String, String> alteredTemplates = new HashMap<String, String>();
            for (Map.Entry<String, String> templateEntry : templates.entrySet()) {
                String template = templateEntry.getValue();
                LOG.debug("Replacing templates in '{}'", (Object)template);
                Matcher matcher = PLACEHOLDER.matcher(template);
                while (matcher.find()) {
                    String group = matcher.group(1).trim();
                    if (!group.startsWith(TEMPLATES_PREFIX)) continue;
                    template = template.replaceAll(PREFIX + group + SUFFIX, templates.get(group.substring(TEMPLATES_PREFIX.length())));
                }
                if (template.equals(templateEntry.getValue())) continue;
                LOG.debug("Found templates to replace, template is now '{}'", (Object)template);
                alteredTemplates.put(templateEntry.getKey(), template);
                templateFound = true;
            }
            templates.putAll(alteredTemplates);
        }
    }
}

