/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.converter.message;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.camunda.community.converter.message.Message;
import org.camunda.community.converter.message.MessageTemplate;
import org.camunda.community.converter.message.MessageTemplateProcessor;

public class MessageTemplateProvider {
    private static final MessageTemplateProcessor MESSAGE_TEMPLATE_PROCESSOR = new MessageTemplateProcessor();
    private static final Map<String, MessageTemplate> MESSAGE_TEMPLATES = new HashMap<String, MessageTemplate>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageTemplate getMessageTemplate(String templateName) {
        MessageTemplate template = null;
        Map<String, MessageTemplate> map = MESSAGE_TEMPLATES;
        synchronized (map) {
            template = MESSAGE_TEMPLATES.get(templateName);
        }
        if (template == null) {
            throw new IllegalStateException("No template found for name '" + templateName + "'");
        }
        return template;
    }

    static {
        Properties loader = new Properties();
        try (InputStream in = Message.class.getClassLoader().getResourceAsStream("message-templates.properties");){
            loader.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> rawTemplates = new HashMap<String, String>();
        loader.stringPropertyNames().forEach(key -> rawTemplates.put((String)key, loader.getProperty((String)key)));
        MESSAGE_TEMPLATE_PROCESSOR.replaceTemplates(rawTemplates);
        rawTemplates.entrySet().forEach(entry -> MESSAGE_TEMPLATES.put((String)entry.getKey(), new MessageTemplate((String)entry.getValue(), MESSAGE_TEMPLATE_PROCESSOR.extractVariables((String)entry.getValue()))));
    }
}

