/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.converter.visitor;

import org.camunda.community.converter.DomElementVisitorContext;
import org.camunda.community.converter.visitor.AbstractFilteringVisitor;

public abstract class AbstractAttributeVisitor
extends AbstractFilteringVisitor {
    @Override
    protected void visitFilteredElement(DomElementVisitorContext context) {
        String attribute = context.getElement().getAttribute(this.namespaceUri(), this.attributeLocalName());
        this.visitAttribute(context, attribute);
        if (this.removeAttribute()) {
            context.addAttributeToRemove(this.attributeLocalName(), this.namespaceUri());
        }
    }

    private String resolveAttribute(DomElementVisitorContext context) {
        return context.getElement().getAttribute(this.namespaceUri(), this.attributeLocalName());
    }

    @Override
    protected boolean canVisit(DomElementVisitorContext context) {
        return this.resolveAttribute(context) != null && context.getElement().getNamespaceURI().equals("http://www.omg.org/spec/BPMN/20100524/MODEL");
    }

    protected String namespaceUri() {
        return "http://camunda.org/schema/1.0/bpmn";
    }

    public abstract String attributeLocalName();

    protected abstract void visitAttribute(DomElementVisitorContext var1, String var2);

    protected boolean removeAttribute() {
        return true;
    }

    @Override
    protected void logVisit(DomElementVisitorContext context) {
        this.LOG.debug("Visiting attribute 'camunda:{}' on element '{}:{}'", this.attributeLocalName(), context.getElement().getPrefix(), context.getElement().getLocalName());
    }
}

