/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.converter.visitor;

import org.camunda.community.converter.BpmnDiagramCheckResult;
import org.camunda.community.converter.DomElementVisitorContext;
import org.camunda.community.converter.convertible.Convertible;
import org.camunda.community.converter.message.MessageFactory;
import org.camunda.community.converter.visitor.AbstractElementVisitor;

public abstract class AbstractProcessElementVisitor
extends AbstractElementVisitor {
    @Override
    protected String namespaceUri() {
        return "http://www.omg.org/spec/BPMN/20100524/MODEL";
    }

    @Override
    protected final void visitFilteredElement(DomElementVisitorContext context) {
        context.setAsBpmnProcessElement(this.createConvertible(context));
        this.postCreationVisitor(context);
        if (!this.canBeConverted(context)) {
            this.addCannotBeConvertedMessage(context);
        }
    }

    public abstract boolean canBeConverted(DomElementVisitorContext var1);

    protected abstract Convertible createConvertible(DomElementVisitorContext var1);

    protected void postCreationVisitor(DomElementVisitorContext context) {
    }

    protected void addCannotBeConvertedMessage(DomElementVisitorContext context) {
        context.addMessage(BpmnDiagramCheckResult.Severity.WARNING, MessageFactory.elementNotSupportedHint(context.getElement().getLocalName(), context.getProperties().getPlatformVersion()));
    }
}

