/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.converter.visitor.impl.element;

import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.converter.DomElementVisitorContext;
import org.camunda.community.converter.convertible.AbstractDataMapperConvertible;
import org.camunda.community.converter.expression.ExpressionTransformationResult;
import org.camunda.community.converter.expression.ExpressionTransformer;
import org.camunda.community.converter.message.Message;
import org.camunda.community.converter.message.MessageFactory;
import org.camunda.community.converter.visitor.AbstractCamundaElementVisitor;

public abstract class InputOutputParameterVisitor
extends AbstractCamundaElementVisitor {
    public static final String INPUT_PARAMETER = "inputParameter";
    public static final String OUTPUT_PARAMETER = "outputParameter";

    @Override
    public boolean canBeTransformed(DomElementVisitorContext context) {
        return !this.isNotStringOrExpression(context.getElement());
    }

    @Override
    protected Message visitCamundaElement(DomElementVisitorContext context) {
        DomElement element = context.getElement();
        String name = element.getAttribute("name");
        AbstractDataMapperConvertible.MappingDirection direction = this.findMappingDirection(element);
        if (this.isNotStringOrExpression(element)) {
            return MessageFactory.inputOutputParameterIsNoExpression(this.localName(), name);
        }
        ExpressionTransformationResult transformationResult = ExpressionTransformer.transform(element.getTextContent());
        context.addConversion(AbstractDataMapperConvertible.class, abstractTaskConversion -> abstractTaskConversion.addZeebeIoMapping(direction, transformationResult.getNewExpression(), name));
        return MessageFactory.inputOutputParameter(this.localName(), name, transformationResult);
    }

    private AbstractDataMapperConvertible.MappingDirection findMappingDirection(DomElement element) {
        if (this.isInputParameter(element.getLocalName())) {
            return AbstractDataMapperConvertible.MappingDirection.INPUT;
        }
        if (this.isOutputParameter(element.getLocalName())) {
            return AbstractDataMapperConvertible.MappingDirection.OUTPUT;
        }
        throw new IllegalStateException("Must be input or output!");
    }

    private boolean isNotStringOrExpression(DomElement element) {
        return element.getChildElements().size() > 0;
    }

    private boolean isInputParameter(String localName) {
        return INPUT_PARAMETER.equals(localName);
    }

    private boolean isOutputParameter(String localName) {
        return OUTPUT_PARAMETER.equals(localName);
    }

    public static class OutputParameterVisitor
    extends InputOutputParameterVisitor {
        @Override
        public String localName() {
            return InputOutputParameterVisitor.OUTPUT_PARAMETER;
        }
    }

    public static class InputParameterVisitor
    extends InputOutputParameterVisitor {
        @Override
        public String localName() {
            return InputOutputParameterVisitor.INPUT_PARAMETER;
        }
    }
}

