/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.converter.visitor.impl.gateway;

import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.converter.BpmnDiagramCheckResult;
import org.camunda.community.converter.DomElementVisitorContext;
import org.camunda.community.converter.convertible.Convertible;
import org.camunda.community.converter.convertible.InclusiveGatewayConvertible;
import org.camunda.community.converter.message.MessageFactory;
import org.camunda.community.converter.version.SemanticVersion;
import org.camunda.community.converter.version.VersionComparison;
import org.camunda.community.converter.visitor.AbstractGatewayVisitor;

public class InclusiveGatewayVisitor
extends AbstractGatewayVisitor {
    @Override
    public String localName() {
        return "inclusiveGateway";
    }

    @Override
    public boolean canBeConverted(DomElementVisitorContext context) {
        return this.isNotJoining(context.getElement()) && this.isRequiredVersion(context);
    }

    private boolean isRequiredVersion(DomElementVisitorContext context) {
        return VersionComparison.isSupported(context.getProperties().getPlatformVersion(), SemanticVersion._8_1_0.toString());
    }

    private boolean isNotJoining(DomElement element) {
        return element.getChildElements().stream().filter(e -> e.getNamespaceURI().equals("http://www.omg.org/spec/BPMN/20100524/MODEL")).filter(e -> e.getLocalName().equals("incoming")).count() <= 1L;
    }

    @Override
    protected Convertible createConvertible(DomElementVisitorContext context) {
        return new InclusiveGatewayConvertible();
    }

    @Override
    protected void addCannotBeConvertedMessage(DomElementVisitorContext context) {
        if (!this.isRequiredVersion(context)) {
            super.addCannotBeConvertedMessage(context);
        } else {
            context.addMessage(BpmnDiagramCheckResult.Severity.WARNING, MessageFactory.inclusiveGatewayJoin());
        }
    }
}

