/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.convertible.Convertible;

public class BpmnDiagramCheckContext {
    private final Set<DomElement> elementsToRemove = new HashSet<DomElement>();
    private final Map<DomElement, Map<String, Set<String>>> attributesToRemove = new HashMap<DomElement, Map<String, Set<String>>>();
    private final Map<DomElement, Convertible> convertibles = new HashMap<DomElement, Convertible>();

    public Map<DomElement, Convertible> getConvertibles() {
        return this.convertibles;
    }

    public Set<DomElement> getElementsToRemove() {
        return this.elementsToRemove;
    }

    public Map<DomElement, Map<String, Set<String>>> getAttributesToRemove() {
        return this.attributesToRemove;
    }

    public void addAttributeToRemove(DomElement element, String namespaceUri, String localName) {
        this.attributesToRemove.computeIfAbsent(element, e -> new HashMap()).computeIfAbsent(namespaceUri, n -> new HashSet()).add(localName);
    }

    public void addConvertible(DomElement element, Convertible convertible) {
        if (this.convertibles.containsKey(element)) {
            throw new IllegalStateException("There must only be one convertible per element!");
        }
        this.convertibles.put(element, convertible);
    }
}

