/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor.impl.activity;

import org.camunda.community.migration.converter.BpmnDiagramCheckResult;
import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.convertible.Convertible;
import org.camunda.community.migration.converter.convertible.ServiceTaskConvertible;
import org.camunda.community.migration.converter.message.MessageFactory;
import org.camunda.community.migration.converter.version.SemanticVersion;
import org.camunda.community.migration.converter.visitor.AbstractActivityVisitor;

public class ScriptTaskVisitor
extends AbstractActivityVisitor {
    @Override
    public String localName() {
        return "scriptTask";
    }

    @Override
    protected Convertible createConvertible(DomElementVisitorContext context) {
        return new ServiceTaskConvertible();
    }

    @Override
    protected void postCreationVisitor(DomElementVisitorContext context) {
        String scriptFormat = context.getElement().getAttribute("http://www.omg.org/spec/BPMN/20100524/MODEL", "scriptFormat");
        if (scriptFormat != null && scriptFormat.trim().length() > 0) {
            context.addConversion(ServiceTaskConvertible.class, convertible -> convertible.addZeebeTaskHeader(context.getProperties().getScriptFormatHeader(), scriptFormat));
            context.addConversion(ServiceTaskConvertible.class, convertible -> convertible.getZeebeTaskDefinition().setType(context.getProperties().getScriptJobType()));
            context.addMessage(BpmnDiagramCheckResult.Severity.TASK, MessageFactory.scriptFormat(context.getProperties().getScriptFormatHeader(), scriptFormat));
            context.addMessage(BpmnDiagramCheckResult.Severity.TASK, MessageFactory.scriptJobType(context.getElement().getLocalName(), context.getProperties().getScriptJobType()));
        } else {
            context.addMessage(BpmnDiagramCheckResult.Severity.TASK, MessageFactory.scriptFormatMissing());
        }
    }

    @Override
    protected SemanticVersion availableFrom(DomElementVisitorContext context) {
        return SemanticVersion._8_0_0;
    }
}

