/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.visitor.impl.element;

import java.util.Optional;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.community.migration.converter.BpmnDiagramCheckResult;
import org.camunda.community.migration.converter.DomElementVisitorContext;
import org.camunda.community.migration.converter.convertible.AbstractDataMapperConvertible;
import org.camunda.community.migration.converter.convertible.CallActivityConvertible;
import org.camunda.community.migration.converter.expression.ExpressionTransformationResult;
import org.camunda.community.migration.converter.expression.ExpressionTransformer;
import org.camunda.community.migration.converter.message.Message;
import org.camunda.community.migration.converter.message.MessageFactory;
import org.camunda.community.migration.converter.visitor.AbstractCamundaElementVisitor;

public abstract class InOutVisitor
extends AbstractCamundaElementVisitor {
    private static final String IN = "in";
    private static final String OUT = "out";

    private boolean isIn(DomElement element) {
        return element.getLocalName().equals(IN);
    }

    private boolean isOut(DomElement element) {
        return element.getLocalName().equals(OUT);
    }

    private AbstractDataMapperConvertible.MappingDirection getDirection(DomElement element) {
        if (this.isIn(element)) {
            return AbstractDataMapperConvertible.MappingDirection.INPUT;
        }
        if (this.isOut(element)) {
            return AbstractDataMapperConvertible.MappingDirection.OUTPUT;
        }
        throw this.mustBeInOrOut();
    }

    private IllegalStateException mustBeInOrOut() {
        return new IllegalStateException("Must be in or out");
    }

    @Override
    public boolean canBeTransformed(DomElementVisitorContext context) {
        DomElement element = context.getElement();
        return !this.isBusinessKey(element);
    }

    @Override
    protected Message visitCamundaElement(DomElementVisitorContext context) {
        DomElement element = context.getElement();
        boolean local = Boolean.getBoolean(Optional.ofNullable(element.getAttribute("local")).orElse(Boolean.toString(false)));
        if (local) {
            context.addMessage(BpmnDiagramCheckResult.Severity.TASK, MessageFactory.localVariablePropagationNotSupported());
        }
        if (this.isAll(context.getElement())) {
            if (this.isIn(context.getElement())) {
                return MessageFactory.inAllNotRecommendedHint();
            }
            if (this.isOut(context.getElement())) {
                context.addConversion(CallActivityConvertible.class, conversion -> conversion.getZeebeCalledElement().setPropagateAllChildVariables(true));
                return MessageFactory.outAllNotRecommendedHint();
            }
            throw this.mustBeInOrOut();
        }
        if (this.isBusinessKey(context.getElement())) {
            return MessageFactory.inOutBusinessKeyNotSupported(context.getElement().getLocalName());
        }
        String target = element.getAttribute("target");
        ExpressionTransformationResult transformationResult = this.createResult(context.getElement());
        context.addConversion(AbstractDataMapperConvertible.class, conversion -> conversion.addZeebeIoMapping(this.getDirection(context.getElement()), transformationResult.getNewExpression(), target));
        return MessageFactory.inputOutputParameter(this.localName(), target, transformationResult);
    }

    private ExpressionTransformationResult createResult(DomElement element) {
        String source = element.getAttribute("source");
        String sourceExpression = element.getAttribute("sourceExpression");
        if (source != null) {
            ExpressionTransformationResult transformationResult = new ExpressionTransformationResult();
            transformationResult.setOldExpression(source);
            transformationResult.setNewExpression("=" + source);
            return transformationResult;
        }
        if (sourceExpression != null) {
            return ExpressionTransformer.transform(sourceExpression);
        }
        throw new IllegalStateException("Must have one of: 'source', 'sourceExpression'");
    }

    private boolean isAll(DomElement element) {
        return "all".equals(element.getAttribute("variables"));
    }

    private boolean isBusinessKey(DomElement element) {
        return element.getAttribute("businessKey") != null;
    }

    public static class OutVisitor
    extends InOutVisitor {
        @Override
        public String localName() {
            return InOutVisitor.OUT;
        }
    }

    public static class InVisitor
    extends InOutVisitor {
        @Override
        public String localName() {
            return InOutVisitor.IN;
        }
    }
}

