/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.builder;

import io.camunda.zeebe.model.bpmn.BpmnModelException;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractBpmnModelElementBuilder;
import io.camunda.zeebe.model.bpmn.instance.Activity;
import io.camunda.zeebe.model.bpmn.instance.Association;
import io.camunda.zeebe.model.bpmn.instance.BaseElement;
import io.camunda.zeebe.model.bpmn.instance.BpmnModelElementInstance;
import io.camunda.zeebe.model.bpmn.instance.CompensateEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Definitions;
import io.camunda.zeebe.model.bpmn.instance.Error;
import io.camunda.zeebe.model.bpmn.instance.ErrorEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Escalation;
import io.camunda.zeebe.model.bpmn.instance.EscalationEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Event;
import io.camunda.zeebe.model.bpmn.instance.ExclusiveGateway;
import io.camunda.zeebe.model.bpmn.instance.ExtensionElements;
import io.camunda.zeebe.model.bpmn.instance.FlowElement;
import io.camunda.zeebe.model.bpmn.instance.FlowNode;
import io.camunda.zeebe.model.bpmn.instance.Gateway;
import io.camunda.zeebe.model.bpmn.instance.Message;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.SequenceFlow;
import io.camunda.zeebe.model.bpmn.instance.Signal;
import io.camunda.zeebe.model.bpmn.instance.SignalEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.model.bpmn.instance.bpmndi.BpmnEdge;
import io.camunda.zeebe.model.bpmn.instance.bpmndi.BpmnPlane;
import io.camunda.zeebe.model.bpmn.instance.bpmndi.BpmnShape;
import io.camunda.zeebe.model.bpmn.instance.dc.Bounds;
import io.camunda.zeebe.model.bpmn.instance.di.Waypoint;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeUserTaskForm;
import java.util.Collection;
import java.util.function.Consumer;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public abstract class AbstractBaseElementBuilder<B extends AbstractBaseElementBuilder<B, E>, E extends BaseElement>
extends AbstractBpmnModelElementBuilder<B, E> {
    public static final double SPACE = 50.0;
    private static final String ZEEBE_EXPRESSION_PREFIX = "=";
    public static final String ZEEBE_EXPRESSION_FORMAT = "=%s";

    protected AbstractBaseElementBuilder(BpmnModelInstance modelInstance, E element, Class<?> selfType) {
        super(modelInstance, element, selfType);
    }

    protected <T extends BpmnModelElementInstance> T createInstance(Class<T> typeClass) {
        return (T)((BpmnModelElementInstance)this.modelInstance.newInstance(typeClass));
    }

    protected <T extends BaseElement> T createInstance(Class<T> typeClass, String identifier) {
        BaseElement instance = (BaseElement)this.createInstance(typeClass);
        if (identifier != null) {
            instance.setId(identifier);
            if (instance instanceof FlowElement) {
                ((FlowElement)instance).setName(identifier);
            }
        }
        return (T)instance;
    }

    protected <T extends BpmnModelElementInstance> T createChild(Class<T> typeClass) {
        return this.createChild(this.element, typeClass);
    }

    protected <T extends BaseElement> T createChild(Class<T> typeClass, String identifier) {
        return this.createChild(this.element, typeClass, identifier);
    }

    protected <T extends BpmnModelElementInstance> T createChild(BpmnModelElementInstance parent, Class<T> typeClass) {
        T instance = this.createInstance(typeClass);
        parent.addChildElement((ModelElementInstance)instance);
        return instance;
    }

    protected <T extends BaseElement> T createChild(BpmnModelElementInstance parent, Class<T> typeClass, String identifier) {
        T instance = this.createInstance(typeClass, identifier);
        parent.addChildElement((ModelElementInstance)instance);
        return instance;
    }

    protected <T extends BpmnModelElementInstance> T createSibling(Class<T> typeClass) {
        T instance = this.createInstance(typeClass);
        ((BaseElement)this.element).getParentElement().addChildElement((ModelElementInstance)instance);
        return instance;
    }

    protected <T extends BaseElement> T createSibling(Class<T> typeClass, String identifier) {
        T instance = this.createInstance(typeClass, identifier);
        ((BaseElement)this.element).getParentElement().addChildElement((ModelElementInstance)instance);
        return instance;
    }

    protected <T extends BpmnModelElementInstance> T getCreateSingleChild(Class<T> typeClass) {
        return this.getCreateSingleChild(this.element, typeClass);
    }

    protected <T extends BpmnModelElementInstance> T getCreateSingleChild(BpmnModelElementInstance parent, Class<T> typeClass) {
        Collection<T> childrenOfType = parent.getChildElementsByType(typeClass);
        if (childrenOfType.isEmpty()) {
            return this.createChild(parent, typeClass);
        }
        if (childrenOfType.size() > 1) {
            throw new BpmnModelException("Element " + parent + " of type " + parent.getElementType().getTypeName() + " has more than one child element of type " + typeClass.getName());
        }
        return (T)((BpmnModelElementInstance)childrenOfType.iterator().next());
    }

    protected <T extends BpmnModelElementInstance> T getCreateSingleExtensionElement(Class<T> typeClass) {
        ExtensionElements extensionElements = this.getCreateSingleChild(ExtensionElements.class);
        return this.getCreateSingleChild(extensionElements, typeClass);
    }

    protected Message findMessageForName(String messageName) {
        Collection<Message> messages = this.modelInstance.getModelElementsByType(Message.class);
        for (Message message : messages) {
            if (!messageName.equals(message.getName())) continue;
            return message;
        }
        Message message = this.createMessage();
        message.setName(messageName);
        return message;
    }

    protected Message createMessage() {
        Definitions definitions = this.modelInstance.getDefinitions();
        Message message = this.createChild(definitions, Message.class);
        return message;
    }

    protected MessageEventDefinition createMessageEventDefinition(String messageName) {
        Message message = this.findMessageForName(messageName);
        MessageEventDefinition messageEventDefinition = this.createInstance(MessageEventDefinition.class);
        messageEventDefinition.setMessage(message);
        return messageEventDefinition;
    }

    protected MessageEventDefinition createEmptyMessageEventDefinition() {
        return this.createInstance(MessageEventDefinition.class);
    }

    protected Signal findSignalForName(String signalName) {
        Signal signal2;
        Collection<Signal> signals = this.modelInstance.getModelElementsByType(Signal.class);
        for (Signal signal2 : signals) {
            if (!signalName.equals(signal2.getName())) continue;
            return signal2;
        }
        Definitions definitions = this.modelInstance.getDefinitions();
        signal2 = this.createChild(definitions, Signal.class);
        signal2.setName(signalName);
        return signal2;
    }

    protected SignalEventDefinition createSignalEventDefinition(String signalName) {
        Signal signal = this.findSignalForName(signalName);
        SignalEventDefinition signalEventDefinition = this.createInstance(SignalEventDefinition.class);
        signalEventDefinition.setSignal(signal);
        return signalEventDefinition;
    }

    protected ErrorEventDefinition findErrorDefinitionForCode(String errorCode) {
        Collection<ErrorEventDefinition> definitions = this.modelInstance.getModelElementsByType(ErrorEventDefinition.class);
        for (ErrorEventDefinition definition : definitions) {
            Error error = definition.getError();
            if (error == null || !error.getErrorCode().equals(errorCode)) continue;
            return definition;
        }
        return null;
    }

    protected Error findErrorForNameAndCode(String errorCode) {
        Error error2;
        Collection<Error> errors = this.modelInstance.getModelElementsByType(Error.class);
        for (Error error2 : errors) {
            if (!errorCode.equals(error2.getErrorCode())) continue;
            return error2;
        }
        Definitions definitions = this.modelInstance.getDefinitions();
        error2 = this.createChild(definitions, Error.class);
        error2.setErrorCode(errorCode);
        return error2;
    }

    protected ErrorEventDefinition createEmptyErrorEventDefinition() {
        ErrorEventDefinition errorEventDefinition = this.createInstance(ErrorEventDefinition.class);
        return errorEventDefinition;
    }

    protected ErrorEventDefinition createErrorEventDefinition(String errorCode) {
        Error error = this.findErrorForNameAndCode(errorCode);
        ErrorEventDefinition errorEventDefinition = this.createInstance(ErrorEventDefinition.class);
        errorEventDefinition.setError(error);
        return errorEventDefinition;
    }

    protected Escalation findEscalationForCode(String escalationCode) {
        Escalation escalation2;
        Collection<Escalation> escalations = this.modelInstance.getModelElementsByType(Escalation.class);
        for (Escalation escalation2 : escalations) {
            if (!escalationCode.equals(escalation2.getEscalationCode())) continue;
            return escalation2;
        }
        Definitions definitions = this.modelInstance.getDefinitions();
        escalation2 = this.createChild(definitions, Escalation.class);
        escalation2.setEscalationCode(escalationCode);
        return escalation2;
    }

    protected EscalationEventDefinition createEscalationEventDefinition(String escalationCode) {
        Escalation escalation = this.findEscalationForCode(escalationCode);
        EscalationEventDefinition escalationEventDefinition = this.createInstance(EscalationEventDefinition.class);
        escalationEventDefinition.setEscalation(escalation);
        return escalationEventDefinition;
    }

    protected CompensateEventDefinition createCompensateEventDefinition() {
        CompensateEventDefinition compensateEventDefinition = this.createInstance(CompensateEventDefinition.class);
        return compensateEventDefinition;
    }

    protected Process findProcess() {
        ModelElementInstance parentElement;
        while ((parentElement = ((BaseElement)this.element).getParentElement()) != null && !(parentElement instanceof Process)) {
        }
        if (parentElement == null) {
            throw new RuntimeException("Unable to find process parent for element " + this.element);
        }
        return (Process)parentElement;
    }

    protected ZeebeUserTaskForm createZeebeUserTaskForm() {
        Process process = this.findProcess();
        ExtensionElements extensionElements = this.getCreateSingleChild(process, ExtensionElements.class);
        return this.createChild(extensionElements, ZeebeUserTaskForm.class);
    }

    public B id(String identifier) {
        ((BaseElement)this.element).setId(identifier);
        return (B)((AbstractBaseElementBuilder)this.myself);
    }

    public B addExtensionElement(BpmnModelElementInstance extensionElement) {
        ExtensionElements extensionElements = this.getCreateSingleChild(ExtensionElements.class);
        extensionElements.addChildElement(extensionElement);
        return (B)((AbstractBaseElementBuilder)this.myself);
    }

    public <T extends BpmnModelElementInstance> B addExtensionElement(Class<T> extensionClass, Consumer<T> builder) {
        T element = this.createInstance(extensionClass);
        builder.accept(element);
        return this.addExtensionElement((BpmnModelElementInstance)element);
    }

    protected String asZeebeExpression(String expression) {
        if (expression != null && !expression.isEmpty() && !expression.startsWith(ZEEBE_EXPRESSION_PREFIX)) {
            return String.format(ZEEBE_EXPRESSION_FORMAT, expression);
        }
        return expression;
    }

    public BpmnShape createBpmnShape(FlowNode node) {
        BpmnPlane bpmnPlane = this.findBpmnPlane();
        if (bpmnPlane != null) {
            BpmnShape bpmnShape = this.createInstance(BpmnShape.class);
            bpmnShape.setBpmnElement(node);
            Bounds nodeBounds = this.createInstance(Bounds.class);
            if (node instanceof SubProcess) {
                bpmnShape.setExpanded(true);
                nodeBounds.setWidth(350.0);
                nodeBounds.setHeight(200.0);
            } else if (node instanceof Activity) {
                nodeBounds.setWidth(100.0);
                nodeBounds.setHeight(80.0);
            } else if (node instanceof Event) {
                nodeBounds.setWidth(36.0);
                nodeBounds.setHeight(36.0);
            } else if (node instanceof Gateway) {
                nodeBounds.setWidth(50.0);
                nodeBounds.setHeight(50.0);
                if (node instanceof ExclusiveGateway) {
                    bpmnShape.setMarkerVisible(true);
                }
            }
            nodeBounds.setX(0.0);
            nodeBounds.setY(0.0);
            bpmnShape.addChildElement(nodeBounds);
            bpmnPlane.addChildElement(bpmnShape);
            return bpmnShape;
        }
        return null;
    }

    protected void setCoordinates(BpmnShape shape) {
        BpmnShape source = this.findBpmnShape((BaseElement)this.element);
        Bounds shapeBounds = shape.getBounds();
        double x = 0.0;
        double y = 0.0;
        if (source != null) {
            Bounds sourceBounds = source.getBounds();
            double sourceX = sourceBounds.getX();
            double sourceWidth = sourceBounds.getWidth();
            x = sourceX + sourceWidth + 50.0;
            if (this.element instanceof FlowNode) {
                FlowNode flowNode = (FlowNode)this.element;
                y = this.getFlowNodeYCoordinate(flowNode, shapeBounds, sourceBounds);
            }
        }
        shapeBounds.setX(x);
        shapeBounds.setY(y);
    }

    public BpmnEdge createEdge(BaseElement baseElement) {
        BpmnPlane bpmnPlane = this.findBpmnPlane();
        if (bpmnPlane != null) {
            BpmnEdge edge = this.createInstance(BpmnEdge.class);
            edge.setBpmnElement(baseElement);
            this.setWaypoints(edge);
            bpmnPlane.addChildElement(edge);
            return edge;
        }
        return null;
    }

    protected void setWaypoints(BpmnEdge edge) {
        FlowNode edgeTarget;
        FlowNode edgeSource;
        BaseElement bpmnElement = edge.getBpmnElement();
        if (bpmnElement instanceof SequenceFlow) {
            SequenceFlow sequenceFlow = (SequenceFlow)bpmnElement;
            edgeSource = sequenceFlow.getSource();
            edgeTarget = sequenceFlow.getTarget();
        } else if (bpmnElement instanceof Association) {
            Association association = (Association)bpmnElement;
            edgeSource = (FlowNode)association.getSource();
            edgeTarget = (FlowNode)association.getTarget();
        } else {
            throw new RuntimeException("Bpmn element type not supported");
        }
        this.setWaypointsWithSourceAndTarget(edge, edgeSource, edgeTarget);
    }

    protected void setWaypointsWithSourceAndTarget(BpmnEdge edge, FlowNode edgeSource, FlowNode edgeTarget) {
        BpmnShape source = this.findBpmnShape(edgeSource);
        BpmnShape target = this.findBpmnShape(edgeTarget);
        if (source != null && target != null) {
            Bounds sourceBounds = source.getBounds();
            Bounds targetBounds = target.getBounds();
            double sourceX = sourceBounds.getX();
            double sourceY = sourceBounds.getY();
            double sourceWidth = sourceBounds.getWidth();
            double sourceHeight = sourceBounds.getHeight();
            double targetX = targetBounds.getX();
            double targetY = targetBounds.getY();
            double targetHeight = targetBounds.getHeight();
            Waypoint w1 = this.createInstance(Waypoint.class);
            if (edgeSource.getOutgoing().size() == 1) {
                w1.setX(sourceX + sourceWidth);
                w1.setY(sourceY + sourceHeight / 2.0);
                edge.addChildElement(w1);
            } else {
                w1.setX(sourceX + sourceWidth / 2.0);
                w1.setY(sourceY + sourceHeight);
                edge.addChildElement(w1);
                Waypoint w2 = this.createInstance(Waypoint.class);
                w2.setX(sourceX + sourceWidth / 2.0);
                w2.setY(targetY + targetHeight / 2.0);
                edge.addChildElement(w2);
            }
            Waypoint w3 = this.createInstance(Waypoint.class);
            w3.setX(targetX);
            w3.setY(targetY + targetHeight / 2.0);
            edge.addChildElement(w3);
        }
    }

    protected BpmnPlane findBpmnPlane() {
        Collection<BpmnPlane> planes = this.modelInstance.getModelElementsByType(BpmnPlane.class);
        return planes.iterator().next();
    }

    protected BpmnShape findBpmnShape(BaseElement node) {
        Collection<BpmnShape> allShapes = this.modelInstance.getModelElementsByType(BpmnShape.class);
        for (BpmnShape shape : allShapes) {
            if (!shape.getBpmnElement().equals(node)) continue;
            return shape;
        }
        return null;
    }

    protected BpmnEdge findBpmnEdge(BaseElement sequenceFlow) {
        Collection<BpmnEdge> allEdges = this.modelInstance.getModelElementsByType(BpmnEdge.class);
        for (BpmnEdge edge : allEdges) {
            if (!edge.getBpmnElement().equals(sequenceFlow)) continue;
            return edge;
        }
        return null;
    }

    protected void resizeSubProcess(BpmnShape innerShape) {
        BpmnShape subProcessShape;
        BaseElement innerElement = innerShape.getBpmnElement();
        Bounds innerShapeBounds = innerShape.getBounds();
        ModelElementInstance parent = innerElement.getParentElement();
        while (parent instanceof SubProcess && (subProcessShape = this.findBpmnShape((SubProcess)parent)) != null) {
            Bounds subProcessBounds = subProcessShape.getBounds();
            double innerX = innerShapeBounds.getX();
            double innerWidth = innerShapeBounds.getWidth();
            double innerY = innerShapeBounds.getY();
            double innerHeight = innerShapeBounds.getHeight();
            double subProcessY = subProcessBounds.getY();
            double subProcessHeight = subProcessBounds.getHeight();
            double subProcessX = subProcessBounds.getX();
            double subProcessWidth = subProcessBounds.getWidth();
            double tmpWidth = innerX + innerWidth + 50.0;
            double tmpHeight = innerY + innerHeight + 50.0;
            if (innerY == subProcessY) {
                subProcessBounds.setY(subProcessY - 50.0);
                subProcessBounds.setHeight(subProcessHeight + 50.0);
            }
            if (tmpWidth >= subProcessX + subProcessWidth) {
                double newWidth = tmpWidth - subProcessX;
                subProcessBounds.setWidth(newWidth);
            }
            if (tmpHeight >= subProcessY + subProcessHeight) {
                double newHeight = tmpHeight - subProcessY;
                subProcessBounds.setHeight(newHeight);
            }
            innerElement = (SubProcess)parent;
            innerShapeBounds = subProcessBounds;
            parent = innerElement.getParentElement();
        }
    }

    private double getFlowNodeYCoordinate(FlowNode flowNode, Bounds shapeBounds, Bounds sourceBounds) {
        Collection<SequenceFlow> outgoing = flowNode.getOutgoing();
        double y = 0.0;
        if (outgoing.size() == 0) {
            double sourceY = sourceBounds.getY();
            double sourceHeight = sourceBounds.getHeight();
            double targetHeight = shapeBounds.getHeight();
            y = sourceY + sourceHeight / 2.0 - targetHeight / 2.0;
        } else {
            SequenceFlow[] sequenceFlows = outgoing.toArray(new SequenceFlow[outgoing.size()]);
            SequenceFlow last = sequenceFlows[outgoing.size() - 1];
            BpmnShape targetShape = this.findBpmnShape(last.getTarget());
            if (targetShape != null) {
                Bounds targetBounds = targetShape.getBounds();
                double lastY = targetBounds.getY();
                double lastHeight = targetBounds.getHeight();
                y = lastY + lastHeight + 50.0;
            }
        }
        return y;
    }
}

