/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.migration.converter.cli;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.community.migration.converter.BpmnConverter;
import org.camunda.community.migration.converter.BpmnConverterFactory;
import org.camunda.community.migration.converter.ConverterPropertiesFactory;
import org.camunda.community.migration.converter.DefaultConverterProperties;
import org.camunda.community.migration.converter.cli.ConvertCommand;
import org.camunda.community.migration.converter.cli.PrintNotificationServiceImpl;
import picocli.CommandLine;

public abstract class AbstractConvertCommand
implements Callable<Integer> {
    private static final String DEFAULT_PREFIX = "converted-c8-";
    protected final BpmnConverter converter;
    @CommandLine.Option(names={"-d", "--documentation"}, description={"If enabled, messages are also appended to documentation"})
    boolean documentation;
    @CommandLine.Option(names={"--adapter-job-type"}, description={"If set, the default value for the adapter job is overridden"})
    String adapterJobType;
    @CommandLine.Option(names={"--prefix"}, description={"Prefix for the name of the generated file"}, defaultValue="converted-c8-")
    String prefix = "converted-c8-";
    @CommandLine.Option(names={"-o", "--override"}, description={"If enabled, existing files are overridden"})
    boolean override;
    @CommandLine.Option(names={"--platform-version"}, description={"Semantic version of the target platform, defaults to latest version"})
    String platformVersion;

    public AbstractConvertCommand() {
        BpmnConverterFactory factory = BpmnConverterFactory.getInstance();
        factory.getNotificationServiceFactory().setInstance(new PrintNotificationServiceImpl());
        this.converter = (BpmnConverter)factory.get();
    }

    @Override
    public final Integer call() throws Exception {
        return this.modelInstances().entrySet().stream().mapToInt(e -> this.handleModel(this.determineFileName((File)e.getKey()), (BpmnModelInstance)e.getValue())).max().orElse(0);
    }

    private int handleModel(File file, BpmnModelInstance modelInstance) {
        try {
            this.converter.convert(modelInstance, this.documentation, ConverterPropertiesFactory.getInstance().merge(this.converterProperties()));
        }
        catch (Exception e) {
            ConvertCommand.LOG_CLI.error("Problem while converting: {}", (Object)e.getMessage());
            return 1;
        }
        if (!this.override && file.exists()) {
            ConvertCommand.LOG_CLI.error("File does already exist: {}", (Object)file);
            return 1;
        }
        ConvertCommand.LOG_CLI.info("Created {}", (Object)file);
        try (FileWriter fw = new FileWriter(file);){
            this.converter.printXml(modelInstance.getDocument(), true, fw);
            fw.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    protected abstract Map<File, BpmnModelInstance> modelInstances() throws Exception;

    protected DefaultConverterProperties converterProperties() {
        DefaultConverterProperties properties = new DefaultConverterProperties();
        properties.setAdapterJobType(this.adapterJobType);
        properties.setPlatformVersion(this.platformVersion);
        return properties;
    }

    private File determineFileName(File file) {
        File newFile = new File(file.getParentFile(), this.prefix + file.getName());
        int counter = 0;
        while (!this.override && newFile.exists()) {
            newFile = new File(file.getParentFile(), this.prefix + FilenameUtils.getBaseName(file.getName()) + " (" + ++counter + ")." + FilenameUtils.getExtension(file.getName()));
        }
        return newFile;
    }
}

